<?php
namespace Xtwo\Minicart\Plugin;

use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Customer\Model\ResourceModel\Customer\CollectionFactory as CustomerCollectionFactory;
use Magento\Customer\Model\AccountManagement;
use Magento\Customer\Api\CustomerRepositoryInterface;

class AccountManagementPlugin
{
    private $customerCollectionFactory;
    private $customerRepository;

    public function __construct(
        CustomerCollectionFactory $customerCollectionFactory,
        CustomerRepositoryInterface $customerRepository
        )
    {
        $this->customerCollectionFactory = $customerCollectionFactory;
        $this->customerRepository = $customerRepository;
    }

    public function aroundCreateAccount(
        AccountManagement $subject,
        callable $proceed,
        CustomerInterface $customer,
        $password = null,
        $redirectUrl = ''
    ) {
        $b2bCustomerValue = $customer->getCustomAttribute('b2b_customer') ? $customer->getCustomAttribute('b2b_customer')->getValue() : null;
        $groupId = $customer->getGroupId();
        if ($b2bCustomerValue === 1) {
            $groupId = 9;
        }
        $result = $proceed($customer, $password, $redirectUrl);
        $customerId = $result->getId();
        $customer = $this->getCustomerById($customerId);
        if($customer){
            $customer->setGroupId($groupId);
            $this->customerRepository->save($customer);
        }
        return true;
    }

    private function getCustomerById(int $customerId): ?CustomerInterface
    {
        $customer = $this->customerRepository->getById($customerId);
        return $customer;
    }
}
