<?php

namespace Xtwo\Metaupdate\Helper;

use \Magento\Framework\App\Helper\AbstractHelper;
class Data extends AbstractHelper{
    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;
    protected $fileResolver;
    protected $hasher;
    protected $taxHelper;
    protected $priceHelper;
    protected $storeInterface;
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Catalog\Helper\Data $taxHelper,
        \Magento\Framework\Pricing\Helper\Data $priceHelper,
        \Magento\Store\Api\Data\StoreInterface $storeInterface,
    ) {
        $this->logger = $logger;
        $this->scopeConfig = $scopeConfig;
        $this->taxHelper = $taxHelper;
        $this->priceHelper = $priceHelper;
        $this->storeInterface = $storeInterface;
        parent::__construct(
            $context
        );
    }

    /**
     * @param $product
     * @param $text
     * @return string
     */
    public function replaceVariables($product, $text) {
        $replacements = array('PREIS'=>'price', 'PRICE'=>'price', 'DATUM' => 'current_date', 'DATE' => 'current_date');
        $result = $text;
        foreach ($replacements as $replacement => $productAttribute) {
            $isHit = (strpos($result, strtolower($replacement)) !== false) ||
                (strpos($result, strtoupper($replacement)) !== false);

            if ($isHit && $productAttribute == 'current_date') {
                $locale = $this->storeInterface->getLocaleCode();
                
                $date = new \Zend_Date();
                $date->setLocale($locale);
                $value = $date->toString(\Zend_Date::DATES);
                $replResult = preg_replace('/{{{\s?'.$replacement.'\s?}}}/i', $value, $result);
                if (is_string($replResult)) {
                    $result = $replResult;
                }
            } else if ($isHit && ($value = $product->getData($productAttribute)))  {
                if ($productAttribute == 'price') {
                    $value = $this->taxHelper->getTaxPrice($product, $value, true);
                    $value = ($value>0) ? $this->priceHelper->currency($value, true, false) : '';
                }
                $replResult = preg_replace('/{{{\s?'.$replacement.'\s?}}}/i', $value, $result);
                if (is_string($replResult)) {
                    $result = $replResult;
                }
            }
        }
        return $result;
    }

}