<?php
namespace Xtwo\Metaupdate\Controller\Index; 
 
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\View\Result\PageFactory; 
use Magento\Catalog\Model\ProductFactory;
class View extends Action
{ 
    protected $_resultPageFactory;
    protected $_resultJsonFactory;
    protected $productModel;  
    protected $productRepository;  
    protected $scopeConfig;  
    protected $helper;  
    
    public function __construct(
        Context $context, 
        PageFactory $resultPageFactory, 
        JsonFactory $resultJsonFactory,
        ProductFactory $productModel,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Xtwo\Metaupdate\Helper\Data $helperData,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository)
    { 
        $this->_resultPageFactory = $resultPageFactory;
        $this->_resultJsonFactory = $resultJsonFactory;
        $this->productModel = $productModel; 
        $this->scopeConfig = $scopeConfig;
        $this->helper = $helperData;
        $this->productRepository = $productRepository;
        parent::__construct($context);
    }
 
    public function execute(){
        $productData = [];
        $currentProductId = $this->getRequest()->getParam('currentproduct');
        $product = $this->productRepository->getById($currentProductId);

        $metaDescription = $product->getData('meta_description');
        if (empty($metaDescription)) $metaDescription = $this->scopeConfig->getValue('design/head/default_description');
        if (!empty($metaDescription)) $metaDescription = $this->helper->replaceVariables($product, $metaDescription);
        
        $productData['meta_description'] = $metaDescription;
        $response = $this->resultFactory
            ->create(\Magento\Framework\Controller\ResultFactory::TYPE_JSON)
            ->setData($productData);

    return $response;
    }
}