<?php

namespace Xtwo\LayerNavGraphQl\Model\Resolver;

use Magento\Catalog\Api\CategoryRepositoryInterface;
use Magento\Catalog\Model\Layer\Resolver as LayerResolver;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\Request\Http as HttpRequest;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;

class CustomLayerNavigation implements ResolverInterface
{
    private $layerResolver;
    private $categoryRepository;
    private $storeManager;
    private $request;

    public function __construct(
        LayerResolver $layerResolver,
        CategoryRepositoryInterface $categoryRepository,
        StoreManagerInterface $storeManager,
        HttpRequest $request
    ) {
        $this->layerResolver = $layerResolver;
        $this->categoryRepository = $categoryRepository;
        $this->storeManager = $storeManager;
        $this->request = $request;
    }

    public function resolve(
        $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        $categoryId = $args['categoryId'] ?? null;
        $customFilters = $args['filters'] ?? [];
        $store = $context->getExtensionAttributes()->getStore();
        if (!$context instanceof ContextInterface) {
        throw new \Magento\Framework\GraphQl\Exception\GraphQlInputException(__('Invalid context.'));
    }
        $storeCode =$this->request->getHeader('Store');
        if ($storeCode) {
            $this->storeManager->setCurrentStore($storeCode);
        }
         $currencyCode =$this->request->getHeader('Currency');
        if(isset($currencyCode) && !empty($currencyCode)){
            $this->storeManager->getStore()->setCurrentCurrencyCode($currencyCode);
        }
         // ✅ Set filters via request parameters (this is critical)
         $filterArrays= [];
        foreach ($customFilters as $filter) {
            $filterArrays[$filter['attribute']][] =$filter['value'];
            if (isset($filter['attribute'], $filter['value'])) {
                //$this->request->setParam($filter['attribute'], $filter['value']);
            }
          
            
        }
        $layer = $this->layerResolver->get();

        if ($categoryId) {
            try {
                $category = $this->categoryRepository->get($categoryId);
                $layer->setCurrentCategory($category);
            } catch (\Exception $e) {
                throw new \Magento\Framework\GraphQl\Exception\GraphQlInputException(__('Invalid category ID.'));
            }
        }
          // Apply filters to Layer
        //$layer->apply();

        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $filterableAttributes = $objectManager->get(\Magento\Catalog\Model\Layer\Category\FilterableAttributeList::class);
        $filterList = $objectManager->create(
            \Magento\Catalog\Model\Layer\FilterList::class,
            ['filterableAttributes' => $filterableAttributes]
        );

        $productCollection = $layer->getProductCollection();
       
    if(!empty($filter['attribute']) && $filter['attribute']=='manufacturer'){
    $productCollection->addAttributeToFilter('manufacturer', array('in' => array($filterArrays['manufacturer'])));
    }
    if(!empty($filter['attribute']) && $filter['attribute']=='color'){

        $this->applyFilter($productCollection, 'color', $filterArrays['color'] ?? null);
    }
    if(!empty($filter['attribute']) && $filter['attribute']=='delivery_time'){
    
        $this->applyFilter($productCollection, 'delivery_time', $filterArrays['delivery_time'] ?? null);
    }
    if(!empty($filter['attribute']) && $filter['attribute']=='connection_size'){
        $this->applyFilter($productCollection, 'connection_size', $filterArrays['connection_size'] ?? null);
    }
    if(!empty($filter['attribute']) && $filter['attribute']=='type2'){
        $this->applyFilter($productCollection, 'type2', $filterArrays['type2'] ?? null);
    }
     if(!empty($filter['attribute']) && $filter['attribute']=='series'){
        $this->applyFilter($productCollection, 'series', $filterArrays['series'] ?? null);
    }
    if(!empty($filter['attribute']) && $filter['attribute']=='price'){
            $priceArr = $filterArrays['price'][0];
        if(!empty($priceArr)){
            $priceFilter = explode('-',$priceArr);
        }
       
        list($from, $to) = $priceFilter;
        $productCollection->addAttributeToFilter('price', ['from'=>$from, 'to'=>$to]);
    }
    
      
        //echo $qurey = $productCollection->getSelect()->__toString(); 
       //dd("Product Collection Size: " . $productCollection->getSize());
        $productCollection->addAttributeToFilter('visibility', ['in' => [\Magento\Catalog\Model\Product\Visibility::VISIBILITY_BOTH, \Magento\Catalog\Model\Product\Visibility::VISIBILITY_IN_CATALOG]]);
        $productCollection->addAttributeToFilter('status', \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED);
 
        $minPrice = $productCollection->getMinPrice();
        $maxPrice = $productCollection->getMaxPrice();

        $filters = $filterList->getFilters($layer);
        $filterArray = [];
         $url = null;
        foreach ($filters as $filter) {
            $attrCode = $filter->getRequestVar();
            $attrLabel = $filter->getName();
            $items = $filter->getItems();
            $values = [];
            if($attrCode !='price'){
                foreach ($items as $item) {
                    $itemLabel = trim((string)$item->getLabel());
                    $itemValue = trim((string)$item->getValue());

                    if ($itemLabel === '' || $itemValue === '') {
                        continue;
                    }
                     $url = null;
                    if ($attrCode == 'cat' && is_numeric($itemValue)) {
                        try {
                            $categoryOption = $this->categoryRepository->get($itemValue);
                            $url = '/category/' . ltrim($categoryOption->getUrlPath(), '/');
                            
                        } catch (\Exception $e) {
                            $url = null;
                        }
                    }

                    $values[] = [
                        'display' => $itemLabel,
                        'value' => $itemValue,
                        'count' => $item->getCount(),
                        'url' => $url // optionally build URL
                    ];
                }

                if (!empty($values)) {
                    $filterArray[] = [
                        'attr_code' => $attrCode,
                        'attr_label' => $attrLabel,
                        'values' => $values,
                    ];
                }
            }
		}

        $sort = [
            'position' => 'Topseller',
            'name' => 'Product Name',
            'price' => 'Price',
            'delivery_time' => 'Delivery Time'
        ];

        return [
            'filters' => $filterArray,
            'sort' => $sort,
            'price' => [
                'min' => $minPrice,
                'max' => $maxPrice
            ]
        ];
    }
     private function applyFilter($collection, $filterKey, $filterValue) {
        if (!empty($filterValue)) {
            $values = is_array($filterValue) ? $filterValue : explode(',', $filterValue);
            $collection->addAttributeToFilter($filterKey, ['in' => $values]);
        }
    }
}
