<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_InfoMailingDirect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */
namespace Xtwo\InfoMailingDirect\Helper;

use \Magento\Framework\App\Helper\AbstractHelper;
class Data extends AbstractHelper
{
    const CONFIGURATION_COUNT = 5;
    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    protected  $HelperBackend;

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Xtwo\SalesMailing\Model\Order\InfoMailing $infoMailing,
        \Magento\Email\Model\BackendTemplate $emailTemplate,
        \Magento\Backend\Helper\Data $HelperBackend

    ) {
        $this->logger = $logger;
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
        $this->infoMailing =$infoMailing;
        $this->emailTemplate = $emailTemplate;
        $this->HelperBackend = $HelperBackend;

        parent::__construct(
            $context
        );
    }

    /**
     * @param $level
     * @param $msg
     */
    public function log($level, $msg) {
        $this->logger->log($msg, $level, 'infomailingdirect.log', true);
    }

    /**
     * Returns the configurations items as data array
     * @param \Magento\Sales\Model\Order $order
     * @return array
     */
    public function getActiveConfigurations($order) {
        $configurations = array();
        $path = 'sales_email/infomailingdirect';

        if (!$this->scopeConfig->getValue($path.'/active',  
        \Magento\Store\Model\ScopeInterface::SCOPE_STORE
        ,$order->getStore())) {
            return $configurations;
        }

        /** @var Xtwo_InfoMailing_Model_Order_InfoMailing $infoMailing */
        $infoMailing = $this->infoMailing->get($order->getId());
        
        if (!$infoMailing || !$infoMailing->getId()) {
            //return $configurations;
        }

        for ($i = 1; $i <=self::CONFIGURATION_COUNT; $i++) {
            $config = array();
            $config['id'] = $i;
            $templateId = $this->scopeConfig->getValue($path.'/direct_template_'.$i,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE, $order->getStore());
           // dd($templateId);
            if ($templateId && is_numeric($templateId)) {

                /** @var Mage_Sales_Model_Email_Template $template */
                $template = $this->emailTemplate->load($templateId);
                //dd($template);
                $buttonTitle = $this->scopeConfig->getValue($path.'/direct_button_'.$i,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE,  $order->getStore());
                if ($buttonTitle && $template && $template->getId()) {

                    $isAlreadySentTime = $this->infoMailing->getTemplateIdSentDateTime($templateId);

                    $config['is_active']    = $isAlreadySentTime ? false : true;
                    $config['button_title'] = $buttonTitle;
                    $config['template_id']  = $templateId;
                    $config['template_subject'] = $template->getTemplateSubject();
                    $config['template_name'] = $template->getTemplateCode();
                    $config['info']         = $isAlreadySentTime ? sprintf(
                        '<span style="color:green">Sent: %s</span>', $isAlreadySentTime) : '';
                    $configurations[$i] = $config;
                }
            }
        }

        return $configurations;
    }

    /**
     * @param $params
     * @return mixed
     */
    public function getSendDirectInfoMailingUrl($params) {
        $url = $this->HelperBackend->getUrl('xtwoinfomailing/info/index', $params);
        return $url;
    }
}