<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_InfoMailingDirect
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\InfoMailingDirect\Controller\Adminhtml\Info;

use Magento\Backend\App\Action;

class Index extends Action 
{
    
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;
    protected $infoMailingObserver;
    protected $orderHistory;
    /**
     * Logging instance
     * @var \YourNamespace\YourModule\Logger\Logger
     */
    protected $_logger;
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        //\Magento\Framework\App\Config $scopeConfig,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Xtwo\InfoMailingDirect\Helper\Data $infoMailingHelper,
        \Xtwo\SalesMailing\Model\Observer $infoMailingObserver,
        \Magento\Sales\Model\Order\Status\History $orderHistory,
        \Xtwo\SalesMailing\Model\Configuration $salesMailingConfig,
        \Xtwo\SalesMailing\Model\Order\InfoMailing $salesOrderMailing,
        \Magento\Framework\Mail\Template\TransportBuilder $emailTemplate,
        \Xtwo\InfoMailingDirect\Logger\Logger $logger,
        \Magento\Email\Model\Template  $coreEmailTemplate

    ){
        $this->infoMailingHelper = $infoMailingHelper;
        $this->orderHistory = $orderHistory;
        $this->salesMailingConfig = $salesMailingConfig;
        $this->salesOrderMailing = $salesOrderMailing;
        $this->emailTemplate = $emailTemplate;
        $this->infoMailingObserver =$infoMailingObserver;
        $this->scopeConfig =$scopeConfig;
        $this->logger = $logger;
        $this->coreEmailTemplate=$coreEmailTemplate;
        parent::__construct($context);

    }
    /**
     * View document
     */
    public function execute()
    {
 
        /** @var Xtwo_InfoMailingDirect_Helper_Data $helper */
        $helper = $this->infoMailingHelper;
        $request = $this->getRequest();
        /** @var Xtwo_InfoMailing_Model_Observer $mailingObserver */
        //$mailingObserver = Mage::getSingleton('xtwo_infomailing/observer');
        $mailingObserver =$this->infoMailingObserver;
        $dd=$mailingObserver->processOrderInfoItems(3);
        $responseData = [];
        $responseData['error']=[];
        try {
            $orderId = $request->getParam('order_id');
            if (!$orderId) {
                $msg = 'OrderId not submitted!';
                $helper->log(\Zend_Log::ERR, $msg);
                throw \Magento\Framework\Exception\LocalizedException($msg);
            }
            $templateId = $request->getParam('template_id');
            if (!$templateId) {
                $msg = 'templateId not submitted!';
                $helper->log(\Zend_Log::ERR, $msg);
                throw \Magento\Framework\Exception\LocalizedException($msg);
            }
            /** @var Xtwo_InfoMailing_Model_Order_InfoMailing $infoMailing */
            //$infoMailing = Mage::getModel('xtwo_infomailing/order_infoMailing')->load($orderId);
            $infoMailing = $this->salesOrderMailing->load($orderId);
            
            $sender = $this->scopeConfig->getValue('sales_email/infomailingdirect/email_identity',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $infoMailing->getOrder()->getStore()
            );
                
            $cc = explode(',', $this->scopeConfig->getValue('sales_email/infomailingdirect/email_cc',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $infoMailing->getOrder()->getStore()
            ));
            $bcc = explode(',', $this->scopeConfig->getValue('sales_email/infomailingdirect/email_bcc',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $infoMailing->getOrder()->getStore()
            ));
           
            /** @var Xtwo_InfoMailing_Model_Configuration $configInstance */
            //$configInstance = Mage::getModel('xtwo_infomailing/configuration');
            $configInstance = $this->salesMailingConfig;
            $configInstance->setData([
                'is_secondary_active'   => false,
                'secondary_mail_active' => false,
                'template_id'           => [$infoMailing->getOrder()->getStoreId() => $templateId],
                'type'                  => 'external',
                'email_identity'        => [$infoMailing->getOrder()->getStoreId() => $sender],
            ]);
            if (!empty($cc)) {
                $configInstance->setCcRecipients($cc);
            }
            if (!empty($bcc)) {
                $configInstance->setBccRecipients($bcc);
                $this->log('Added Bcc: ' . implode(',', $bcc), \Zend_Log::INFO);
            }
            $infoMailResult = $mailingObserver->queueInfoMail($infoMailing, $configInstance);
            
            $processLog = sprintf('%s [status=%s] %s', date('Y-m-d H:i:s'),
                $infoMailing->getStatus(), $infoMailResult->getStatusInfoAsString() . ' (direct mailing)');
            $infoMailing->addProcessLog($processLog)->save();

            $this->log('Order#' .$orderId . ' | ' . $processLog, \Zend_Log::INFO);
            
            /** @var //Mage_Sales_Model_Email_Template $template */
            //$template = Mage::getModel('core/email_template')->load($templateId);            
            //$template = $this->emailTemplate->load($templateId);
            $template =$this->coreEmailTemplate->load($templateId);
            
            //$history = Mage::getModel('sales/order_status_history')
            $history = $this->orderHistory
                ->setStatus($infoMailing->getOrder()->getStatus())
                ->setComment('E-Mail Communication: sent Template "' . $template->getTemplateCode() . '"')
                //->setEntityName(\Magento\Sales\Model\Order::HISTORY_ENTITY_NAME)
                ->setEntityName('creditmemo')
                ->setIsCustomerNotified(true);
            $infoMailing->getOrder()->addStatusHistory($history);
            $infoMailing->getOrder()->save();

            $isError = $infoMailResult->getStatus() != \Xtwo\SalesMailing\Model\QueueInfoMailResult::STATUS_SUCCESS;
            $responseData['error'] = $isError;
            if ($isError) throw \Magento\Framework\Exception\LocalizedException($infoMailResult->getStatus());

        } catch (Exception $e) {
            $responseData['error'] = true;
            $responseData['msg'] = $e->getMessage();
            $helper->log(\Zend_Log::ERR, 'Unexpected: ' . $e->getTraceAsString());

        } catch (Throwable $t) {
            $responseData['error'] = true;
            $responseData['msg'] = $t->getMessage();
            $helper->log(\Zend_Log::ERR, 'Unexpected: ' . $t->getTraceAsString());

        } finally {

            $this->getResponse()
                ->setHttpResponseCode($responseData['error'] ? 500 : 200)
                ->setHeader('Cache-Control', 'must-revalidate, post-check=0, pre-check=0', true)
                ->setHeader('Content-type', 'application/json', true)
                ->setHeader('Last-Modified', date('r'))
                ->setBody(json_encode($responseData))
                ->sendResponse();
            exit(0);
        }
    }

    /**
     * @param $msg
     * @param $level
     */
    protected function log($msg, $level) {
        $this->logger->info( $msg);
    }


    //protected function _isAllowed()
    //{
    //    return true;// Mage::getSingleton('admin/session')->isAllowed('sales/order/documents');
    //}
}