<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_Automationshell
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

namespace Xtwo\Freight\Model;

use Magento\Quote\Model\Quote\Address\RateRequest;

class Carrier extends \Magento\Shipping\Model\Carrier\AbstractCarrier
    implements \Magento\Shipping\Model\Carrier\CarrierInterface
{
    /**
     * Carrier's code, as defined in parent class
     *
     * @var string
     */
    protected $_code = 'freight';

    /**
     * @var \Magento\Shipping\Model\Rate\ResultFactory
     */
    protected $shippingRateResultFactory;

    /**
     * @var \Magento\Catalog\Model\ProductFactory
     */
    protected $catalogProductFactory;

    /**
     * @var \Magento\Quote\Model\Quote\Address\RateResult\MethodFactory
     */
    protected $quoteQuoteAddressRateResultMethodFactory;

    /**
     * @param \Magento\Shipping\Model\Rate\ResultFactory
     * @param \Magento\Catalog\Model\ProductFactory
     * @param \Magento\Quote\Model\Quote\Address\RateResult\MethodFactory
     * @param \Magento\OfflineShipping\Model\ResourceModel\Carrier\Tablerate
     * 
     */

    public function __construct(
        \Magento\Shipping\Model\Rate\ResultFactory $shippingRateResultFactory,
        \Magento\Catalog\Model\ProductFactory $catalogProductFactory,
        \Magento\Quote\Model\Quote\Address\RateResult\MethodFactory $quoteQuoteAddressRateResultMethodFactory,
        \Magento\OfflineShipping\Model\ResourceModel\Carrier\Tablerate $tableRate
    ) {
        $this->shippingRateResultFactory = $shippingRateResultFactory;
        $this->catalogProductFactory = $catalogProductFactory;
        $this->quoteQuoteAddressRateResultMethodFactory = $quoteQuoteAddressRateResultMethodFactory;
        $this->tableRate = $tableRate;
    }
    /**
     *
     * @param \Magento\Quote\Model\Quote\Address\RateRequest $request
     * @return \Magento\Shipping\Model\Rate\Result
     */
    public function collectRates(\Magento\Quote\Model\Quote\Address\RateRequest $request)
    {
        /** @var \Magento\Shipping\Model\Rate\Result $result */
        $result = $this->shippingRateResultFactory->create();
		
		$oldWeight = $request->getPackageWeight();
		
		$shipping_forwarding = false;
		$attribute_shipping_forwarding = $this->getConfigData('attribute_spedition');
        if ($request->getAllItems()) {
        	foreach ($request->getAllItems() as $item) {
        		if ($item->getProduct()->isVirtual() || $item->getParentItem()) {
        			continue;
        		}
        		$product_id = $item->getProductId();
        		$productObj = $this->catalogProductFactory->create()->load($product_id);
        		if($productObj->getData($attribute_shipping_forwarding)) {
					$shipping_forwarding = true;
        		}
        	}
        }

		$weight_spedition = doubleval($this->getConfigData('weight_spedition'));
		
		if ($shipping_forwarding && $oldWeight < $weight_spedition) {
			// Gewicht = $weight_spedition + 0.1
			// Preis anhand neuem Gewicht
			// Spedition als Versand setzen
			$request->setPackageWeight($weight_spedition + 0.1);
			$shipping_forwarding = true;
		} else {
			// Preis anhand Table Rate und Gewicht Warenkorb (STANDARD)
			if ($oldWeight > $weight_spedition) {
				// Spedition als Versand setzen
				$request->setPackageWeight($oldWeight);
				$shipping_forwarding = true;			
			} else {
				// Table rate standard
				$shipping_forwarding = false;
				$request->setPackageWeight($oldWeight);
			}
				
		}

        if ($shipping_forwarding) {
			$result->append($this->_getStandardRate($request));
		} else {
			return null;
		}

        return $result;
    }

    /**
     * Returns Allowed shipping methods
     *
     * @return array
     */
    public function getAllowedMethods()
    {
        return array(
            'freight'    =>  'Freight Delivery'
        );
    }

    /**
     * Get Standard rate object
     *
     * @return \Magento\Quote\Model\Quote\Address\RateResult\Method
     */
    protected function _getStandardRate($request)
    {	
		// $cost = Mage::getResourceModel('shipping/carrier_tablerate')->getRate($request);
        $cost = $this->tableRate->create()->getRate($request);
		
		/** @var \Magento\Quote\Model\Quote\Address\RateResult\Method $rate */
		$rate = $this->quoteQuoteAddressRateResultMethodFactory->create();
		
		$rate->setCarrier($this->_code);
		$rate->setCarrierTitle($this->getConfigData('title'));
		$rate->setMethod('freight');
		$rate->setMethodTitle($this->getConfigData('name'));
		
		if (!empty($cost) && $cost['price'] >= 0) {
			$rate->setPrice(round($cost['price'],3));
        	$rate->setCost($cost['cost']);
			
		} 
		if ( $request->getFreeShipping() == true) {
				$rate->setPrice(0);
				$rate->setCost(0);

		}
        return $rate;
    }


    public function isTrackingAvailable()
    {
        return true;
    }

}