<?php
namespace Xtwo\FieldCustomOption\Plugin;

use Magento\Quote\Model\Quote;
use Magento\Catalog\Model\Product;
use Xtwo\FieldCustomOption\Model\QtyFactory;

class QuotePlugin
{
    /**
     * @var QtyFactory
     */
    private $qtyFactory;

    /**
     * Constructor
     *
     * @param QtyFactory $qtyFactory
     */
    public function __construct(QtyFactory $qtyFactory)
    {
        $this->qtyFactory = $qtyFactory;
    }

    /**
     * Before Add Product Plugin for Quote
     *
     * @param Quote $subject
     * @param Product $product
     * @param null|array|\Magento\Framework\DataObject $request
     * @param string $processMode
     * @return array
     */
    public function beforeAddProduct(
        Quote $subject,
        Product $product,
        $request = null,
        $processMode = Product\Type\AbstractType::PROCESS_MODE_FULL
    ) {
        if (is_object($request) && method_exists($request, 'getOptions')) {
            $options = $request->getOptions();

            if (empty($options) || !is_array($options)) {
                return [$product, $request, $processMode];
            }

            $currentQty = $request->getQty() ?: 1;
            $customOptions = [];
            $totalQtyMultiplier = 1;

            foreach ($options as $optionId => $optionValue) {
                $qtyUnitData = $this->qtyFactory->create()->getCollection()
                    ->getItemByColumnValue('option_type_id', $optionValue);

                if ($qtyUnitData) {
                    $qtyMultiplier = $qtyUnitData->getQtyOption() ?: 1;  
                    $totalQtyMultiplier *= $qtyMultiplier; 
                } else {
                    $customOptions[$optionId] = $optionValue;
                }
            }

            $adjustedQty = $currentQty * $totalQtyMultiplier;
            $request->setQty($adjustedQty);
            $request->setOptions($customOptions);
        }

        return [$product, $request, $processMode];
    }
}