<?php

namespace Xtwo\FieldCustomOption\Plugin;

class OptionValuePlugin
{
    
    /**
     * @var \Mageants\Customoptionimage\Model\ImageUrlFactory
     */
    private $qtyFactory;

    /**
     * Intisilize Constructor
     *
     * @param \Mageants\Customoptionimage\Model\ImageUrlFactory $qtyFactory
     */
    public function __construct(
        \Xtwo\FieldCustomOption\Model\QtyFactory $qtyFactory
    ) {
        $this->qtyFactory = $qtyFactory;
    }

    /**
     * Save Values
     *
     * @param \Magento\Catalog\Model\Product\Option\Value $subject
     * @param object $proceed
     * @return void
     */
    public function aroundSave(
        \Magento\Catalog\Model\Product\Option\Value $subject,
        $proceed
    ) {
        $proceed();
        $qtyModel = $this->qtyFactory->create()->getCollection()
            ->getItemByColumnValue('option_type_id', $subject->getOptionTypeId());
        if (!$qtyModel) {
            $qtyModel = $this->qtyFactory->create();
        }
        $qtyModel
            ->setOptionTypeId($subject->getOptionTypeId())
            ->setQtyOption($subject->getQtyOption())
            ->setUnitOption($subject->getUnitOption())
            ->save();
    }

    /**
     * Get Data
     *
     * @param \Magento\Catalog\Model\Product\Option\Value $subject
     * @param object $proceed
     * @param string $key
     * @param mixed $index
     * @return void
     */
    public function aroundGetData(
        \Magento\Catalog\Model\Product\Option\Value $subject,
        $proceed,
        $key = '',
        $index = null
    ) {
        $result = $proceed($key, $index);
        
        if ($key === '') {
            if (isset($result['option_type_id']) && !isset($result['qty_option'])) {
                $qtyData = $this->qtyFactory->create()->getCollection()
                    ->getItemByColumnValue('option_type_id', $result['option_type_id']);
                $unitData = $this->qtyFactory->create()->getCollection()
                ->getItemByColumnValue('option_type_id', $result['option_type_id']);
                if ($qtyData) {
                    $qtyData = $qtyData->getQtyOption();
                }
                if ($unitData) {
                    $unitData = $unitData->getUnitOption();
                }
                $result['qty_option'] = $qtyData;
                 $result['unit_option'] = $unitData;
            }
        }

        if ($key === 'qty_option' && $subject->getData('option_type_id') && !$subject->hasData('qty_option')) {
            $qtyData = $this->qtyFactory->create()->getCollection()
                ->getItemByColumnValue('option_type_id', $subject->getData('option_type_id'));
            if ($qtyData) {
                $qtyData = $qtyData->getQtyOption();
            }
            
            return $qtyData;
        }
        if ($key === 'unit_option' && $subject->getData('option_type_id') && !$subject->hasData('unit_option')) {

            $unitData = $this->qtyFactory->create()->getCollection()
            ->getItemByColumnValue('option_type_id', $subject->getData('option_type_id'));
            
            if ($unitData) {
                $unitData = $unitData->getUnitOption();
            }
            return $unitData;
        }

        return $result;
    }

    
}
