<?php

namespace Xtwo\FieldCustomOption\Plugin\Block\Options\Type;

class Select extends \Magento\Catalog\Block\Product\View\Options\Type\Select
{
    public function afterGetValuesHtml(
        \Magento\Catalog\Block\Product\View\Options\Type\Select $subject,
        $result
    ) {
        $_option = $subject->getOption();
        $configValue = $subject
            ->getProduct()
            ->getPreconfiguredValues()
            ->getData("options/" . $_option->getId());
        $store = $subject->getProduct()->getStore();

        $subject->setSkipJsReloadPrice(1);
        // Remove inline prototype onclick and onchange events

        if (
            $_option->getType() ==
                \Magento\Catalog\Model\Product\Option::OPTION_TYPE_DROP_DOWN ||
            $_option->getType() ==
                \Magento\Catalog\Model\Product\Option::OPTION_TYPE_MULTIPLE
        ) {
            $require = $_option->getIsRequire() ? " required" : "";
            $qty_unit_obj = [];
            foreach ($_option->getValues() as $_value) {
                $qty_unit_obj[$_value->getOptionTypeId()] = array('qty_option' => $_value->getQtyOption(), 'unit_option' => $_value->getUnitOption(), 'option_price' => $_value->getPrice());
            }
            $qty_unit_json = "";
            if(!empty($qty_unit_obj)){
                $qty_unit_json = json_encode($qty_unit_obj);
            }

            $extraParams = "";
            if($qty_unit_json != ""){
                $extraParams .= " data-qtyunitjson='" . $qty_unit_json . "'";
            }

            $select = $subject
                ->getLayout()
                ->createBlock("Magento\Framework\View\Element\Html\Select")
                ->setData([
                    "id" => "select_" . $_option->getId(),
                    "class" =>
                        $require .
                        " product-custom-option admin__control-select",
                ]);
            $select->setExtraParams($extraParams);
           if ($_option->getType() === \Magento\Catalog\Model\Product\Option::OPTION_TYPE_DROP_DOWN){
                $select->setName('options[' . $_option->getId() . ']')->addOption('', __('-- Please Select --'));
            } else {
                $select->setName('options[' . $_option->getId() . '][]');
                $select->setClass('multiselect admin__control-multiselect' . $require . ' product-custom-option');
            }
            foreach ($_option->getValues() as $_value) {
                $priceStr = $subject->_formatPrice(
                    [
                        "is_percent" => $_value->getPriceType() == "percent",
                        "pricing_value" => $_value->getPrice(
                            $_value->getPriceType() == "percent"
                        ),
                    ],
                    false
                );
                $select->addOption(
                    $_value->getOptionTypeId(),
                    $_value->getTitle() . " " . strip_tags($priceStr) . "",
                    [
                        "price" => $subject->pricingHelper->currencyByStore(
                            $_value->getPrice(true),
                            $store,
                            false
                        ),
                    ]
                );
            }
            if (
                $_option->getType() ==
                \Magento\Catalog\Model\Product\Option::OPTION_TYPE_MULTIPLE
            ) {
                $extraParams = ' multiple="multiple"';
            }
            if (!$subject->getSkipJsReloadPrice()) {
                $extraParams .= ' onchange="opConfig.reloadPrice()"';
            }
            $extraParams .= ' data-selector="' . $select->getName() . '"';
            $select->setExtraParams($extraParams);

            if ($configValue) {
                $select->setValue($configValue);
            }

            return $select->getHtml();
        }

        
    }
}
