<?php

/**
 * @category Mageants Customoptionimage
 * @package Mageants_Customoptionimage
 * @copyright Copyright (c) 2022 Mageants
 * @author Mageants Team <support@Mageants.com>
 */

namespace Xtwo\FieldCustomOption\Observer\Adminhtml;

use \Magento\Framework\Event\ObserverInterface;
use \Magento\Framework\Event\Observer as EventObserver;
use Magento\Ui\Component\Form\Field;
use Magento\Ui\Component\Form\Element\Checkbox;
use Magento\Ui\Component\Form\Element\DataType\Text;
use Magento\Ui\Component\Form\Element\DataType\Media;
use Magento\Framework\UrlInterface;
use Magento\Ui\Component\Form\Element\Input;
use Magento\Ui\Component\Form\Element\DataType\Number;


class AddBackendField implements ObserverInterface
{

    public const FIELD_QTY = 'qty_option';

    public const FIELD_UNIT = 'unit_option';

    /**
     * @var \Magento\Framework\UrlInterface
     */
    protected $urlBuilder;

    /**
     * Initilize function
     *
     * @param UrlInterface $urlBuilder
     */
    public function __construct(
        UrlInterface $urlBuilder
    ) {
        $this->urlBuilder = $urlBuilder;
    }
    /**
     * Observer function
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $observer->getChild()->addData($this->getCustomImageField());
    }
    /**
     * Get Custom Image Fields
     *
     * @return void
     */
    protected function getCustomImageField()
    {
        return [
            230 => ['index' => static::FIELD_QTY, 'field' => $this->getQtyFieldConfig(230)],
            240 => ['index' => static::FIELD_UNIT, 'field' => $this->getUnitFieldConfig(240)]
        ];
    }

    /**
     * Generate Preview
     *
     * @param mixed $sortOrder
     * @return object
     */
    protected function getQtyFieldConfig($sortOrder)
    {
         return [
            'arguments' => [
                'data' => [
                    'config' => [
                        'label' => __('Qty'),
                        'componentType' => Field::NAME,
                        'formElement' => Input::NAME,
                        'dataScope' => "qty_option",
                        'dataType' => Number::NAME,
                        'sortOrder' => $sortOrder,
    
                    ],
                ],
            ],
        ];
    }

    /**
     * Upload Button function
     *
     * @param mixed $sortOrder
     * @return object
     */
    protected function getUnitFieldConfig($sortOrder)
    {
        return [
            'arguments' => [
                'data' => [
                    'config' => [
                        'label' => __('Unit'),
                        'componentType' => Field::NAME,
                        'formElement' => Input::NAME,
                        'dataScope' => "unit_option",
                        'dataType' => Text::NAME,
                        'sortOrder' => $sortOrder,
                    ],
                ],
            ],
        ];
    }
}
