<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Xtwo\Emailorder\Model\Rewrite;


class Order extends \Magento\Sales\Model\Order
{
    
    
    public function getCustomerName()
    {
        /*
        * Code modification to get customer first name and last name from the billing address collections
        * If customer first name is empty or null
        */

        if (null === $this->getCustomerFirstname()) {
            foreach ($this->getAddresses() as $billingaddress) {
                if ($billingaddress->getAddressType() == 'billing' && !$billingaddress->isDeleted()) {
                    return $billingaddress->getFirstname() . ' ' . $billingaddress->getLastname();
                }
            }
        }

        $customerName = '';
        $prefix = $this->getCustomerPrefix();
        if ($prefix !== null && strlen($prefix)) {
            $customerName .= $prefix . ' ';
        }
        $customerName .= $this->getCustomerFirstname();
        $middlename = $this->getCustomerMiddlename();
        if ($middlename !== null && strlen($middlename)) {
            $customerName .= ' ' . $middlename;
        }
        $customerName .= ' ' . $this->getCustomerLastname();
        $suffix = $this->getCustomerSuffix();
        if ($suffix !== null && strlen($suffix)) {
            $customerName .= ' ' . $suffix;
        }

        return $customerName;
    }
    
}
