<?php
/**
 * Copyright ©  All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Xtwo\CustomizeMsrp\Rewrite\Magento\Msrp\Ui\DataProvider\Product\Form\Modifier;


use Magento\Catalog\Model\Locator\LocatorInterface;
use Magento\Msrp\Model\Config as MsrpConfig;
use Magento\Framework\Stdlib\ArrayManager;

class Msrp extends \Magento\Msrp\Ui\DataProvider\Product\Form\Modifier\Msrp
{

    /**#@-*/
    protected $locator;

    /**
     * @var MsrpConfig
     */
    protected $msrpConfig;

    /**
     * @var ArrayManager
     */
    protected $arrayManager;

    /**
     * @param LocatorInterface $locator
     * @param MsrpConfig $msrpConfig
     * @param ArrayManager $arrayManager
     */
    public function __construct(
        LocatorInterface $locator,
        MsrpConfig $msrpConfig,
        ArrayManager $arrayManager
    ) {
        parent::__construct($locator, $msrpConfig, $arrayManager);
        $this->locator = $locator;
        $this->msrpConfig = $msrpConfig;
        $this->arrayManager = $arrayManager;
    }

    /**
     * Customize msrp field
     *
     * @return $this
     */
    protected function customizeMsrp()
    {
        $msrpPath = $this->arrayManager->findPath(static::FIELD_MSRP, $this->meta, null, 'children');

        if ($msrpPath) {
            $this->meta = $this->arrayManager->merge(
                $msrpPath . '/arguments/data/config',
                $this->meta,
                [
                    'addbefore' => $this->locator->getStore()->getBaseCurrency()->getCurrencySymbol(),
                    'validation' => ['validate-zero-or-greater' => true],
                ]
            );
        }

        return $this;
    }
}

