<?php
namespace Xtwo\CustomApis\Ui\Component\Listing\Column;

use Magento\Catalog\Model\Product;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use Magento\ConfigurableProduct\Model\ResourceModel\Product\Type\Configurable as configurableProduct;

class ConfigurableProductId extends Column
{
    protected $_productTypeConfigurable;

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        configurableProduct $configurableProduct,

        array $components = [],
        array $data = []
    ) {
        $this->_productTypeConfigurable = $configurableProduct;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $productId = $item['entity_id'];
                $productType = $item['type_id'];
                $configProductId = $this->_productTypeConfigurable->getParentIdsByChild($productId);

                if ($productType === 'simple') {
                    if(empty($configProductId[0])){
                        $item['configurable_product_id'] = '-';
                    }else{
                        $item['configurable_product_id'] = $configProductId[0];
                    }
                }else{
                    $item['configurable_product_id'] = $productId;
                }
            }
        }

        return $dataSource;
    }
}
