<?php
 
namespace Xtwo\CustomApis\Plugin;
 
use Magento\Checkout\Api\Data\PaymentDetailsExtensionFactory;
use Magento\Checkout\Model\ShippingInformationManagement as Subject;
use Magento\Framework\App\RequestInterface;
use Magento\Catalog\Model\ProductRepository;
use Magento\Tax\Api\TaxCalculationInterface;
use Magento\Tax\Model\Calculation;
use Psr\Log\LoggerInterface;
use Magento\Quote\Api\CartRepositoryInterface;
use Fooman\Surcharge\Helper\SurchargeConfig;
use Fooman\Surcharge\Model\ResourceModel\Surcharge\CollectionFactory;
use \Fooman\Surcharge\Model\SurchargeRestrictor;
use Magento\Quote\Api\CartTotalRepositoryInterface;
use Magento\Quote\Api\Data\CartItemInterfaceFactory;
use Magento\InventorySalesApi\Api\IsProductSalableInterface;
use Magento\InventoryApi\Api\Data\SourceItemInterfaceFactory;
use Magento\Quote\Api\CartItemRepositoryInterface;
use Magento\Quote\Api\PaymentMethodManagementInterface;
use Magento\Framework\DataObjectFactory;
use Magento\Quote\Api\Data\PaymentInterfaceFactory;
use Fooman\OrderFees\Model\OrderFeeType;
use Magento\Quote\Model\Quote\Address\Total;
use Magento\Quote\Model\QuoteManagement;
 
class ShippingInformationManagementPlugin
{
    const FIXED = 'fixed';
 
    const PERCENT = 'percent';
 
    const FIXED_PLUS_PERCENT = 'fixed_plus_percent';
 
    const FIXED_MINIMUM = 'fixed_minimum';
 
    protected $paymentDetailsExtensionFactory;
    protected $request;
    protected $productRepository;
    protected $taxCalculation;
    protected $taxCalculationTool;
    protected $logger;
    protected $cartRepository;
    protected $foomanCollectionFactory;
    private $quoteItemFactory;
    private $isProductSalable;
    private $sourceItemFactory;
    private $cartItemRepository;
    /**
     * @var \Fooman\Totals\Model\QuoteAddressTotalFactory
     */
    private $quoteAddressTotalFactory;
    /**
     * @var SurchargeConfig
     */
    private $surchargeConfigHelper;
    /**
     * @var SurchargeRestrictor
     */
    private $surchargeRestrictor;
    protected $cartTotalRepository;
    private $tsProductAdded = false;
    private $dataObjectFactory;
    private $paymentMethodManagement;
    private $paymentInterfaceFactory;
    private $orderFeeType;
    private $totals;
    private $quoteManagement;
	private $currencyHelper;
 
    public function __construct(
        PaymentDetailsExtensionFactory $paymentDetailsExtensionFactory,
        RequestInterface $request,
        ProductRepository $productRepository,
        TaxCalculationInterface $taxCalculation,
        Calculation $taxCalculationTool,
        LoggerInterface $logger,
        CartRepositoryInterface $cartRepository,
        CollectionFactory $foomanCollectionFactory,
        SurchargeConfig $surchargeConfigHelper,
        \Fooman\Totals\Model\QuoteAddressTotalFactory $quoteAddressTotalFactory,
        SurchargeRestrictor $surchargeRestrictor,
        CartTotalRepositoryInterface $cartTotalRepository,
        CartItemInterfaceFactory $quoteItemFactory,
        IsProductSalableInterface $isProductSalable,
        SourceItemInterfaceFactory $sourceItemFactory,
        CartItemRepositoryInterface $cartItemRepository,
        PaymentInterfaceFactory $paymentInterfaceFactory,
        DataObjectFactory $dataObjectFactory,
        OrderFeeType $orderFeeType,
        PaymentMethodManagementInterface $paymentMethodManagement,
        Total $totals,
        QuoteManagement $quoteManagement,
		\Fooman\Surcharge\Helper\Currency $currencyHelper
 
    ) {
        $this->paymentDetailsExtensionFactory = $paymentDetailsExtensionFactory;
        $this->request = $request;
        $this->productRepository = $productRepository;
        $this->taxCalculation = $taxCalculation;
        $this->taxCalculationTool = $taxCalculationTool;
        $this->logger = $logger;
        $this->cartRepository = $cartRepository;
        $this->surchargeConfigHelper = $surchargeConfigHelper;
        $this->quoteAddressTotalFactory = $quoteAddressTotalFactory;
        $this->foomanCollectionFactory = $foomanCollectionFactory;
        $this->surchargeRestrictor = $surchargeRestrictor;
        $this->cartTotalRepository = $cartTotalRepository;
        $this->quoteItemFactory = $quoteItemFactory;
        $this->isProductSalable = $isProductSalable;
        $this->sourceItemFactory = $sourceItemFactory;
        $this->cartItemRepository = $cartItemRepository;
        $this->paymentMethodManagement = $paymentMethodManagement;
        $this->dataObjectFactory = $dataObjectFactory;
        $this->paymentMethodManagement = $paymentMethodManagement;
        $this->paymentInterfaceFactory = $paymentInterfaceFactory;
        $this->orderFeeType = $orderFeeType;
        $this->totals = $totals;
        $this->quoteManagement = $quoteManagement;
		$this->currencyHelper = $currencyHelper;
 
    }
 
    public function aroundSaveAddressInformation(
        Subject $subject,
        callable $proceed,
        $cartId,
        \Magento\Checkout\Api\Data\ShippingInformationInterface $addressInformation
    ) {
 
        $tsProductId = $this->request->getParam('tsProductId');
        $paymentSelected = $this->request->getParam('payment_selected');
        $paymentMethod = $this->request->getParam('payment_method') ?: null;
 
        $paymentDetails = $proceed($cartId, $addressInformation);
        $totalsData = $paymentDetails->getTotals();
 
        /*if($paymentSelected == 1){
                $paymentMethodDataObject = $this->paymentInterfaceFactory->create();
                $paymentMethodDataObject->setMethod($paymentMethod);
                $this->paymentMethodManagement->set($cartId, $paymentMethodDataObject);
 
                $paymentDetails->setPaymentMethod($paymentMethod);
            }*/
 
        $taxRate = 0;
        foreach($totalsData['items'] as $item){
            $taxRate = $item['tax'];
        }
        $quote = $this->cartRepository->getActive($cartId);
 
        $enabledSurcharges = $this->getEnabledOrderFeesSurcharges($quote->getStoreId());
        $foomanLabel = "";
		$type2Array = [];
        foreach ($enabledSurcharges as $enabledSurcharge) {
            $dataRule = json_decode($enabledSurcharge['data_rule'],true);
            if(!empty($dataRule) && array_key_exists('payment',$dataRule)){
                $dataRule['payment'][0] = in_array($paymentMethod, $dataRule['payment']);
                $surchargePayment =  $dataRule['payment'][0];
            }
            if(!empty($dataRule) && array_key_exists('shipping',$dataRule)){
                $surchargeShipping =  $dataRule['shipping'][0];
                $ship = $addressInformation['shipping_carrier_code'];
                if($ship == "simpleshipping"){
                    $ship = "simpleshipping_simpleshipping";
                }
            }
 
            $config = $this->surchargeConfigHelper->getConfig($enabledSurcharge);
			//print_r($enabledSurcharge->getdata());
            $typeId = $enabledSurcharge->getTypeId();
            /** @var \Fooman\Totals\Model\QuoteAddressTotal $total */
            $total = $this->quoteAddressTotalFactory->create();
            $amount = 0;
            $currentSubtotal = $totalsData['base_subtotal'] + ($totalsData['base_shipping_incl_tax'] - $totalsData['base_shipping_tax_amount']);
			
			if ($currentSubtotal < $this->getEnforcedAmount($config, $quote))
			{
				$this->enforceAmount($quote, $total, $currentSubtotal, $config);
                $total->setLabel($enabledSurcharge->getDescription());
			}

                if ($this->surchargeRestrictor->surchargeApplies($quote, $config, $currentSubtotal)) {
                    switch ($config->getCalculationMode()) {
                        case self::FIXED:
                            $amount = $config->getFixed();
                            break;
 
                        case self::PERCENT:
                            $amount = $currentSubtotal * $config->getRate() / 100;
                            break;
 
                        case self::FIXED_PLUS_PERCENT:
                            $amount = ($currentSubtotal * $config->getRate() / 100)
                                + $config->getFixed();
                            break;
 
                        case self::FIXED_MINIMUM:
                            $amount = $currentSubtotal * $config->getRate() / 100;
                            if ($amount < $config->getFixed()) {
                                $amount = $config->getFixed();
                            }
                            break;
                        default:
                            $amount = 0;
                    }
                }
                $amount;
				
                if ($amount > 0 && !empty($amount)){
					$total->setTypeId($typeId);
					$total->setType($enabledSurcharge->getType());
					$total->setCode(\Fooman\Surcharge\Model\Surcharge::CODE);
					if ($surchargePayment == $paymentMethod && $enabledSurcharge->getType() == "payment")
						{
							$total->setLabel($enabledSurcharge->getDescription());
						}
					elseif($enabledSurcharge->getType() == "orderfee")
						{
							$total->setLabel($enabledSurcharge->getDescription());
						}
					elseif($enabledSurcharge->getType() == "shipping" && $surchargeShipping == $ship)
						{
							$total->setLabel($enabledSurcharge->getDescription());
						}
					else
						{
							$total->setLabel('');
						}
					$total->setBaseAmount($amount);
					if (!empty($enabledSurcharge) && strlen($total->getLabel()>1)){
					$foomanLabel = $foomanLabel. " + " .$total->getLabel();
					}
					
                }
				$finalFooman = $total->getData();
				$total->setAmount($this->currencyHelper->convertToQuoteCurrency($quote, $total->getBaseAmount()));
				if(!empty($total->getLabel()))
				{
					$type2Array[] = [
								'title' => $total->getLabel(),
								'values' => (float)$total->getAmount()
							 ];
				}
								
        }
        $foomanLabel = substr(trim($foomanLabel), 2);

        if ($tsProductId !== null && !$this->tsProductAdded) {
 
            /*foreach($totalsData['items'] as $item){
                if ($item['product_type'] == 'buyerprotect') {
 
                $quote->removeItem($item['id']);
            }
            }*/
 
            $tsProductRepo = $this->productRepository->getById($tsProductId);
            $totalSegments = $totalsData['total_segments'] ?? [];
            $quoteCart = $this->cartRepository->get($cartId);
				            
			$subTotalIncludTax = $totalsData['subtotal_incl_tax'] ?? 0;
			$subTotalIncludTax -= $tsProductRepo->getPrice();
			$totalsData['subtotal_incl_tax'] = $subTotalIncludTax;

            $product = $this->productRepository->getById($tsProductId);
 
            //$this->addProductToQuote($quote, $product);       //Add product to cart programatically
 
            $totalSegments[] = [
                'code' => 'trusted_shop',
                'title' => 'KÄUFERSCHUTZ BIS',
                'value' => $tsProductRepo->getPrice(),
            ];
 
            $totalsShow = $this->cartTotalRepository->get($cartId);
            foreach ($totalsShow->getTotalSegments() as $totalSegmentShow) {
                $codeShow = $totalSegmentShow->getCode();
                if ($codeShow === 'fooman_surcharge' && $paymentSelected == 1) {
                        $totalSegments[] = [
                            'code' => 'fooman_tobeused',
                            'title' => $foomanLabel,
                            'value1' => $totalSegmentShow->getValue(),
                        ];
                }
            }
 
            $totalSegments[] = [
                'code' => 'tax_percent',
                'title' => 'Tax Percent',
                'value' => $taxRate,
            ];
 
                $quoteCart->collectTotals($quote);
                $this->cartRepository->save($quote);
 
                $totalsData['total_segments'] = $totalSegments;
                $paymentDetails->setTotals($totalsData);
 
        } else {
 
            $quoteCart = $this->cartRepository->get($cartId);
 
            /* if($paymentSelected == 1){
                $paymentMethodDataObject = $this->paymentInterfaceFactory->create();
                $paymentMethodDataObject->setMethod($paymentMethod);
                $this->paymentMethodManagement->set($cartId, $paymentMethodDataObject);
 
                $paymentDetails->setPaymentMethod($paymentMethod);
            }
            foreach($totalsData['items'] as $item){
                if ($item['product_type'] == 'buyerprotect') {
                $quote->removeItem($item['id']);
            }
            }*/
 
            $totalSegments = $totalsData['total_segments'] ?? [];
            $totalSegments[] = [
                'code' => 'tax_percent',
                'title' => 'Tax Percent',
                'value' => $taxRate,
            ];
 
            $totalsShow = $this->cartTotalRepository->get($cartId);
            foreach ($totalsShow->getTotalSegments() as $totalSegmentShow) {
                $codeShow = $totalSegmentShow->getCode();
                if ($codeShow === 'fooman_surcharge' && $paymentSelected == 1) {
                        $totalSegments[] = [
                            'code' => 'fooman_tobeused',
                            'value' => $type2Array,
                        ];
                }
            }
 
            $quoteCart->collectTotals($quote);
            $this->cartRepository->save($quote);
 
            $totalsData['total_segments'] = $totalSegments;
            $paymentDetails->setTotals($totalsData);
 
        }
 
        return $paymentDetails;
    }
 
    private function getEnabledOrderFeesSurcharges($storeId)
    {
        $collection = $this->foomanCollectionFactory->create();
        //$collection->addFieldToFilter('type', $this->orderFeeType->getType());
        $collection->addFieldToFilter('is_active', 1);
        $collection->addFieldToFilter('store_id', [$storeId, \Magento\Store\Model\Store::DEFAULT_STORE_ID]);
 
        return $collection;
    }
	
	/// enforced
	public function getEnforcedAmount($config, $quote)
    {
        return $config->getEnforcedAmount();
    }
			
	 private function enforceAmount($quote, $total, $currentSubtotal, $config)
		{			
			$total->setBaseAmount($this->currencyHelper->round($config->getEnforcedAmount() - $currentSubtotal));
			$total->setAmount($this->currencyHelper->convertToQuoteCurrency($quote, $total->getBaseAmount()));
		}
			
	/// enforced
 
    /*private function addProductToQuote($quote, $product)
    {
        $quoteItem = $this->createQuoteItem($product);
        $quote->addItem($quoteItem);
    }
    private function createQuoteItem($product)
    {
        $quoteItem = $this->quoteItemFactory->create();
        $quoteItem->setProduct($product);
        $quoteItem->setQty(1);
 
        return $quoteItem;
    }*/
 
}