<?php

namespace Xtwo\CustomApis\Plugin;

use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Framework\Exception\AuthorizationException;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Sales\Model\OrderFactory;
use Magento\Sales\Model\ResourceModel\Order as OrderResource;
use Magento\Framework\App\RequestInterface;

class OrderRepositoryPlugin
{
    protected $orderFactory;
    protected $orderResource;
    protected $request;

    public function __construct(
        OrderFactory $orderFactory,
        OrderResource $orderResource,
        RequestInterface $request
    ) {
        $this->orderFactory = $orderFactory;
        $this->orderResource = $orderResource;
        $this->request = $request;
    }

    public function beforeGet(OrderRepositoryInterface $subject, $id)
    {
        $isCustomApiCall = $this->request->getParam('apiCall');
        $customerId = $this->request->getParam('customerId', null);
        $email = $this->request->getParam('email', null);
        $storeId = $this->request->getParam('storeId', null);

        if ($isCustomApiCall !== 'true') {
            return;
        }

        if (empty($email)) {
            throw new NoSuchEntityException(__('Email is required'));
        }

        if (empty($storeId)) {
            throw new NoSuchEntityException(__('Store Id is required'));
        }

        if (!$id) {
            throw new InputException(__('An ID is needed. Set the ID and try again.'));
        }

        $order = $this->orderFactory->create();
        $this->orderResource->load($order, $id);

        if (!$order->getEntityId()) {
            throw new NoSuchEntityException(__('The entity that was requested doesn\'t exist. Verify the entity and try again.'));
        }

        $orderCustomerId = $order->getCustomerId();
        $orderEmail = $order->getCustomerEmail();
        $orderStoreId = $order->getStoreId();
        if ($orderCustomerId) {
            if ($orderCustomerId != $customerId) {
                throw new AuthorizationException(__('You are not authorized to view this order.'));
            }
        } else {
            if ($orderEmail !== $email || $orderStoreId != $storeId) {
                throw new AuthorizationException(__('You are not authorized to view this order.'));
            }
        }
    } 
}
