<?php

namespace Xtwo\CustomApis\Plugin\Email;

use Magento\Sales\Model\Order\Email\Sender\OrderSender;
use Magento\Sales\Model\Order;

class OrderSenderPlugin
{
    /**
     * @var OrderLogger
     */
    private $orderLogger;

    /**
     * Constructor
     *
     * @param LoggerInterface $logger
     * @param OrderLogger $orderLogger
     */
    public function __construct(\Xtwo\AutoFillSearch\Logger\Logger $orderLogger)
    {
        $this->orderLogger = $orderLogger;
    }

    /**
     * Around plugin for send method
     *
     * @param OrderSender $subject
     * @param \Closure $proceed
     * @param Order $order
     * @param bool $forceSyncMode
     * @return void
     */
    public function aroundSend(
        OrderSender $subject,
        \Closure $proceed,
        Order $order,
        $forceSyncMode = false
    ) {
        // Log the attempt to send the order email using the custom order logger
        $this->orderLogger->info('Attempting to send order email.', ['order_id' => $order->getId()]);
        try {
            // Proceed with sending the email
            $result = $proceed($order, $forceSyncMode);
            // Log successful email sending
            $this->orderLogger->info('Order email sent successfully.', ['order_id' => $order->getId()]);
            return $result;
        } catch (\Exception $e) {
            // Log the error with custom order logger
            $this->orderLogger->error('Failed to send order email.', [
                'order_id' => $order->getId(),
                'error' => $e->getMessage()
            ]);
            throw $e; // Rethrow the exception to maintain normal behavior
        }
    }
}
