<?php

namespace Xtwo\CustomApis\Plugin\Checkout\Model;

use Magento\Quote\Api\Data\PaymentInterface;
use Magento\Quote\Api\Data\AddressInterface;
use Magento\Quote\Model\QuoteIdMaskFactory;
use Magento\Framework\Registry;
use Magento\Checkout\Model\PaymentInformationManagement;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Model\Order\Email\Sender\OrderSender;

class PaymentInformationManagementPlugin
{
    private $orderRepository;
    protected $helper;
    protected $request;
	protected $orderSender;
	 

    public function __construct(
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Xtwo\CustomApis\Helper\Data $helper,
        \Magento\Framework\App\RequestInterface $request,
		OrderSender $orderSender

        )
    {
        $this->orderRepository = $orderRepository;
        $this->helper = $helper;
        $this->request = $request;
		$this->orderSender = $orderSender;
    }

    /**
     * Modify the behavior of savePaymentInformationAndPlaceOrder
     *
     * @param \Magento\Checkout\Model\PaymentInformationManagement $subject
     * @param \Closure $proceed
     * @param string $cartId
     * @param PaymentInterface $paymentMethod
     * @param AddressInterface|null $billingAddress
     * @return array Basic order information
     */
    public function aroundSavePaymentInformationAndPlaceOrder(
        \Magento\Checkout\Model\PaymentInformationManagement $subject,
        \Closure $proceed,
        $cartId,
        PaymentInterface $paymentMethod,
        AddressInterface $billingAddress = null
    ) {
				
        $orderId = $proceed($cartId, $paymentMethod, $billingAddress);
        $order = $this->orderRepository->get($orderId);
        $orderIncrementId = $order->getIncrementId();
		
        $registry = \Magento\Framework\App\ObjectManager::getInstance()->get(\Magento\Framework\Registry::class);
        $registry->registry('payone_authorization_response');
        $basicInfo['order_id'] = $orderId;
        $basicInfo['payone_authorization_response'] = $registry->registry('payone_authorization_response');
		$basicInfo['order_increment_id'] = $orderIncrementId;
        return [$basicInfo];
    }
}