<?php

namespace Xtwo\CustomApis\Plugin\Checkout\Model;

use Magento\Quote\Api\Data\PaymentInterface;
use Magento\Quote\Api\Data\AddressInterface;
use Magento\Quote\Model\QuoteIdMaskFactory;

use Magento\Sales\Model\Order\Email\Sender\OrderSender;

class GuestPaymentInformationManagementPlugin
{
    /**
     * @var QuoteIdMaskFactory
     */
    private $quoteIdMaskFactory;

    /**
     * @var \Magento\Sales\Api\OrderRepositoryInterface
     */
    private $orderRepository;

    /**
     * @var \Xtwo\CustomApis\Helper\Data
     */
    private $helper;

    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    private $request;
	/**
     * @var OrderSender
     */
    private $orderSender;

    public function __construct(
        QuoteIdMaskFactory $quoteIdMaskFactory,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Xtwo\CustomApis\Helper\Data $helper,
        \Magento\Framework\App\RequestInterface $request,
		OrderSender $orderSender
    ) {
        $this->quoteIdMaskFactory = $quoteIdMaskFactory;
        $this->orderRepository = $orderRepository;
        $this->helper = $helper;
        $this->request = $request;
		$this->orderSender = $orderSender;
    }

    /**
     * Modify the behavior of savePaymentInformationAndPlaceOrder
     *
     * @param \Magento\Checkout\Model\GuestPaymentInformationManagement $subject
     * @param \Closure $proceed
     * @param string $cartId
     * @param string $email
     * @param PaymentInterface $paymentMethod
     * @param AddressInterface|null $billingAddress
     * @return string Order increment ID instead of order ID
     */
    public function aroundSavePaymentInformationAndPlaceOrder(
        \Magento\Checkout\Model\GuestPaymentInformationManagement $subject,
        \Closure $proceed,
        $cartId,
        $email,
        PaymentInterface $paymentMethod,
        AddressInterface $billingAddress = null
    ) {
		$basicInfo = [];
        $orderId = $proceed($cartId, $email, $paymentMethod, $billingAddress);
        $order = $this->orderRepository->get($orderId);
        $orderIncrementId = $order->getIncrementId();
				
        $registry = \Magento\Framework\App\ObjectManager::getInstance()->get(\Magento\Framework\Registry::class);
        $registry->registry('payone_authorization_response');
        $basicInfo['order_id'] = $orderId;
        $basicInfo['payone_authorization_response'] = $registry->registry('payone_authorization_response');
		$basicInfo['order_increment_id'] = $orderIncrementId;
        return [$basicInfo];
    }
}