<?php
namespace Xtwo\CustomApis\Model;

use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory as ProductCollectionFactory;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory as CategoryCollectionFactory;
use Magento\Framework\Exception\NotFoundException;

class UrlIdentifier implements \Xtwo\CustomApis\Api\UrlIdentifierInterface
{
    /**
     * @var ProductCollectionFactory
     */
    private $productCollectionFactory;

    /**
     * @var CategoryCollectionFactory
     */
    private $categoryCollectionFactory;

    /**
     * UrlIdentifier constructor.
     * @param ProductCollectionFactory $productCollectionFactory
     * @param CategoryCollectionFactory $categoryCollectionFactory
     */
    public function __construct(
        ProductCollectionFactory $productCollectionFactory,
        CategoryCollectionFactory $categoryCollectionFactory
    ) {
        $this->productCollectionFactory = $productCollectionFactory;
        $this->categoryCollectionFactory = $categoryCollectionFactory;
    }

    /**
     * @inheritdoc
     */
    public function identifyUrlType($data)
    {
        $mainCatUrl = str_replace('.html', '', $data['mainCategory']);
        $subCatUrl1 = str_replace('.html', '', $data['subCategory1']);
        $subCatUrl2 = str_replace('.html', '', $data['subCategory2']);
        if ($this->isProductUrl($mainCatUrl)) {
            return 'Product URL';
        }
        elseif ($this->isCategoryUrl([$mainCatUrl, $subCatUrl1, $subCatUrl2])) {
            return 'Category URL';
        }
        else {
            throw new NotFoundException(__('Unknown URL'));
        }
    }

    private function isProductUrl($urlKey)
    {
        $productCollection = $this->productCollectionFactory->create();
        $productCollection->addAttributeToFilter('url_key', $urlKey)
                          ->setPageSize(1)
                          ->setCurPage(1)
                          ->addFieldToSelect('entity_id');
        return (bool) $productCollection->getSize();
    }

    private function isCategoryUrl(array $categoryUrls)
    {
        $categoryCollection = $this->categoryCollectionFactory->create();
        $categoryCollection->addAttributeToFilter('url_key', ['in' => $categoryUrls])
                           ->setPageSize(1)
                           ->setCurPage(1)
                           ->addFieldToSelect('entity_id');
        return (bool) $categoryCollection->getSize();
    }
}