<?php
namespace Xtwo\CustomApis\Model;

use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Directory\Model\CurrencyFactory;
use Xtwo\CustomApis\Api\SetQuoteCurrencyInterface;
use Magento\Framework\Exception\LocalizedException;
use Psr\Log\LoggerInterface;

class SetQuoteCurrency implements SetQuoteCurrencyInterface
{
    protected $quoteRepository;
    protected $currencyFactory;
    protected $logger;
	protected $storeManager;

    public function __construct(
        CartRepositoryInterface $quoteRepository,
        CurrencyFactory $currencyFactory,
        LoggerInterface $logger,
		\Magento\Store\Model\StoreManagerInterface $storemanager
    ) {
        $this->quoteRepository = $quoteRepository;
        $this->currencyFactory = $currencyFactory;
        $this->logger = $logger;
		$this->storeManager =  $storemanager;
    }

    /**
     * @inheritdoc
     */
    public function SetQuoteCurrency($quoteId, $currencyCode)
    {
		try {
			$this->storeManager->getStore()->setCurrentCurrencyCode($currencyCode);
            $quote = $this->quoteRepository->get($quoteId);
            $currency = $this->currencyFactory->create()->load($currencyCode);
			
			// Get the store for the quote
            $store = $this->storeManager->getStore($quote->getStoreId());
			
			// Check if the currency is available for the store
            $availableCurrencies = $store->getAvailableCurrencyCodes();
            if (!in_array($currencyCode, $availableCurrencies)) {
                throw new LocalizedException(__('Currency code %1 is not available for the store.', $currencyCode));
            }

            $quote->setQuoteCurrencyCode($currencyCode);
            $quote->collectTotals();

            $this->quoteRepository->save($quote);
			$currencyData['name']['Selected_currency_codes'] = $quote->getQuoteCurrencyCode();;
            return $currencyData;
        } catch (NoSuchEntityException $e) {
            throw new LocalizedException(__('Quote does not exist.'));
        } catch (\Exception $e) {
            throw new LocalizedException(__('An error occurred while setting the currency: %1', $e->getMessage()));
        }
        
    }
}
