<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Xtwo\CustomApis\Model;

use Magento\SalesRule\Model\RulesApplier as MagentoRulesApplier;


/**
 * Rule applier model
 *
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class RulesApplier extends MagentoRulesApplier
{
    public function applyRules($item, $rules, $skipValidation, $couponCode)
    {
        $address = $item->getAddress();
        $appliedRuleIds = [];
        /* @var $rule Rule */
        foreach ($rules as $rule) {
            if (!$this->validatorUtility->canProcessRule($rule, $address)) {
                continue;
            }
            
			if ($item->getProductType() === 'buyerprotect') {
				continue;
			}

            $this->applyRule($item, $rule, $address, $couponCode);
            $appliedRuleIds[$rule->getRuleId()] = $rule->getRuleId();
        }

        return $appliedRuleIds;
    }
}
