<?php
namespace Xtwo\CustomApis\Model;

use Xtwo\CustomApis\Api\ReviewManagementInterface;
use Magento\Review\Model\ReviewFactory;
use Magento\Review\Model\RatingFactory;
use Magento\Catalog\Model\ProductFactory;
use Magento\Customer\Model\CustomerFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NotFoundException;

class ReviewManagement implements ReviewManagementInterface
{
    protected $reviewFactory;
    protected $ratingFactory;
    protected $productFactory;
    protected $customerFactory;
    protected $storeManager;

    public function __construct(
        ReviewFactory $reviewFactory,
        RatingFactory $ratingFactory,
        ProductFactory $productFactory,
        CustomerFactory $customerFactory,
        StoreManagerInterface $storeManager
    ) {
        $this->reviewFactory = $reviewFactory;
        $this->ratingFactory = $ratingFactory;
        $this->productFactory = $productFactory;
        $this->customerFactory = $customerFactory;
        $this->storeManager = $storeManager;
    }

    public function setReviewAndRating($data)
    {
        $productId = $data['product_id'];
        $nickName = $data['nickname'];
        $customerId = $data['customer_id'];
        $rating = $data['review_data']['rating'];
        $summary = $data['review_data']['title'];
        $evaluation = $data['review_data']['detail'];

        $existingReview = $this->reviewFactory->create()
            ->getCollection()
            ->addFieldToFilter('entity_pk_value', $productId)
            ->addFieldToFilter('customer_id', $customerId)
            ->getFirstItem();

        if ($existingReview->getId()) {
            throw new \Exception(__('You have already reviewed this product.'));
        }

        $customer = $this->customerFactory->create()->load($customerId);
        $product = $this->productFactory->create()->load($productId);
        $review = $this->reviewFactory->create()->setData([
            'entity_pk_value' => $product->getId(),
            'status_id' => \Magento\Review\Model\Review::STATUS_PENDING,
            'title' => $summary,
            'detail' => $evaluation,
            'entity_id' => 1,
            'store_id' => $this->storeManager->getStore()->getId(),
            'stores' => [$this->storeManager->getStore()->getId()],
            'customer_id' => $customer->getId(),
            'nickname' => $nickName
        ]);

        try {
            $review->save();
            $ratingOptions = $this->loadProductRatingOptions($rating);

            foreach ($ratingOptions as $ratingId => $optionId) {
                $this->ratingFactory->create()
                    ->setRatingId($ratingId)
                    ->setReviewId($review->getId())
                    ->addOptionVote($optionId, $productId);
            }

            return true;
        } catch (\Exception $e) {
            throw new NotFoundException(__('Review data is incomplete'));
        }
    }

    protected function loadProductRatingOptions($desiredRating)
    {
        $ratingOptions = [];

        $ratingCollection = $this->ratingFactory->create()->getResourceCollection()
            ->addEntityFilter('product')
            ->setPositionOrder()
            ->addRatingPerStoreName(\Magento\Store\Model\Store::DEFAULT_STORE_ID)
            ->setStoreFilter(\Magento\Store\Model\Store::DEFAULT_STORE_ID)
            ->load();
        foreach ($ratingCollection as $rating) {
            $options = $rating->getOptions();
            foreach ($options as $option) {
                if ($option->getValue() == $desiredRating) {
                    $ratingOptions[$rating->getId()] = $option->getId();
                }
            }
        }
        return $ratingOptions;
    }

}
