<?php

namespace Xtwo\CustomApis\Model;

use Magento\Review\Model\RatingFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Review\Model\ResourceModel\Review\CollectionFactory as ReviewCollectionFactory;
use Magento\Review\Model\ResourceModel\Rating\Option\Vote\Collection as RatingOptionCollection;

class ProductReview implements \Xtwo\CustomApis\Api\ProductReviewInterface
{
    protected $reviewFactory;
    protected $ratingFactory;
    protected $ratingOption;

    public function __construct(
        ReviewCollectionFactory $reviewFactory,
        RatingFactory $ratingFactory,
        RatingOptionCollection $ratingOption
    ) {
        $this->reviewFactory = $reviewFactory;
        $this->ratingFactory = $ratingFactory;
        $this->ratingOption = $ratingOption;
    }

    public function getProductReviewsAndRatings($productId, $storeId, $currentPage, $pageSize)
    {
        $reviewCollection = $this->reviewFactory->create()
            ->addFieldToSelect(['review_id', 'created_at'])
            ->addStatusFilter(\Magento\Review\Model\Review::STATUS_APPROVED)
            ->addEntityFilter('product', $productId)
            ->addStoreFilter($storeId)
            ->setCurPage($currentPage)
            ->setPageSize($pageSize)
            ->setDateOrder();

        $reviewCollection->getSelect()->join(
            ['rd' => $reviewCollection->getTable('review_detail')],
            'main_table.review_id = rd.review_id',
            ['nickname', 'title', 'detail']
        );

        $reviews = [];
        $ratings = $this->getRatingsForReviews($reviewCollection);

        foreach ($reviewCollection as $review) {
            $reviewData = [
                'review_id' => $review->getId(),
                'created_date' => date("d-m-Y", strtotime($review->getCreatedAt())),
                'nickname' => $review->getNickname(),
                'rating' => $ratings[$review->getId()] ?? 0,
                'title' => $review->getTitle(),
                'detail' => $review->getDetail(),
            ];

            $reviews[] = $reviewData;
        }

        $actualTotalCount = $reviewCollection->getSize();

        $finalResponse = [
            'review_data' => $reviews,
            'searchCriteria' => [
                'page_size' => $pageSize,
                'current_page' => $currentPage,
                'total_count' => $actualTotalCount,
            ],
        ];

        return [$finalResponse];
    }

    public function getRatingsForReviews($reviewCollection)
    {
        $reviewIds = [];
        foreach ($reviewCollection as $review) {
            $reviewIds[] = $review->getId();
        }

        $ratings = [];
        if (!empty($reviewIds)) {
            $ratingCollection = $this->ratingOption
                ->addRatingInfo()
                ->addOptionInfo()
                ->addRatingOptions()
                ->addFieldToFilter('review_id', ['in' => $reviewIds]);

            foreach ($ratingCollection as $data) {
                $ratings[$data->getReviewId()] = $data->getValue();
            }
        }
        return $ratings;
    }
}
