<?php

namespace Xtwo\CustomApis\Model;


use Xtwo\CustomApis\Api\PayoneInterface;
use Magento\Framework\Exception\LocalizedException;


class Payone implements PayoneInterface
{
    /**
     * performing the HTTP POST request to the PAYONE platform
     *
     * @param array $request
     * @param string $responsetype
     * @return array|\Psr\Http\Message\StreamInterface Returns an array of response
     *     parameters in "classic" mode, a Stream for any other mode.
     * @throws Exception
     */
   public function payoneInformation($data)
    {
       
		// appends the accept: application/json header to the request
		// This is used to retrieve structured JSON in the response
		$client = new \GuzzleHttp\Client(['headers' => ['accept' => 'application/json']]);

        if ($response = $client->request('POST', 'https://secure.pay1.de/client-api/', ['form_params' => $data])) {
			//print_r($data);
	    if (implode($response->getHeader('Content-Type')) == 'text/plain; charset=UTF-8' || 
	        implode($response->getHeader('Content-Type')) == 'text/plain; charset=ISO-8859-1') {
                // if the content type is text/plain, parse response into array
			$return = self::parseResponse($response);
            } 
			else {
                // if the content type is anything else, decode response body and parse into array
                // we can safely assume it's JSON because of the way the API currently works
				$response = $response->getBody();
			$return = json_decode($response, true);
            }

        } else {
            throw new Exception('Something went wrong during the HTTP request.');
        }

        return [$return];
    }

}		



