<?php
declare(strict_types=1);

namespace Xtwo\CustomApis\Model;

use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\Data\OrderSearchResultInterface;

class OrderRepository extends \Magento\Sales\Model\OrderRepository
{
    /**
     * Find entities by criteria
     *
     * @param SearchCriteriaInterface $searchCriteria
     * @return OrderSearchResultInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria)
    {
        $searchResult = parent::getList($searchCriteria);

        foreach ($searchResult->getItems() as $order) {
            $this->modifyDateFormat($order);
        }

        return $searchResult;
    }

    /**
     * Modify the date format in the order object
     *
     * @param OrderInterface $order
     */
    private function modifyDateFormat(OrderInterface $order)
    {
        $createdAt = $order->getCreatedAt();
        $formattedDate = date('d.m.y', strtotime($createdAt));
        $order->setCreatedAt($formattedDate);
    }
}
