<?php

namespace Xtwo\CustomApis\Model;

use Xtwo\CustomApis\Api\LocationBasedInterface;
use Magento\Store\Model\StoreManagerInterface;
use Xtwo\CustomApis\Helper\Data as CustomApisHelper;
use Magento\Framework\Exception\LocalizedException;

class LocationBased implements LocationBasedInterface
{
    protected $storeManager;
    protected $customApisHelper;
    protected $_localeCurrency;
    protected $currencyHelper;

    public function __construct(
        StoreManagerInterface $storeManager,
        CustomApisHelper $customApisHelper,
        \Magento\Framework\Locale\CurrencyInterface $localeCurrency,
        \Mageplaza\CurrencyFormatter\Helper\Data $currencyHelper
    ) {
        $this->storeManager = $storeManager;
        $this->customApisHelper = $customApisHelper;
        $this->_localeCurrency = $localeCurrency;
        $this->currencyHelper = $currencyHelper;
    }
    /**
     * @inheritDoc
     */

    public function getLocationBased($existingCountryCode, $targetCountryCode, $existingStoreId, $targetStoreId)
    {
        if (!$this->customApisHelper->checkCountryAndStoreMatching($existingCountryCode, $existingStoreId)) {
            throw new LocalizedException(__('Existing country code and store ID do not match.'));
        }

        $countryData = [];

        $shoppingFrom = [
            'country_flag' => $this->customApisHelper->getCountryFlagIconUrl($existingCountryCode),
            'country_name' => $this->customApisHelper->getCountryName($existingCountryCode),
            'store_url' => $this->customApisHelper->getStoreUrlByStoreId($existingStoreId),
            'currency_symbol' => $this->customApisHelper->getCurrencySymbol($existingStoreId),
        ];
        $countryData['shopping_from'] = $shoppingFrom;

        $shopTo = [
            'country_flag' => $this->customApisHelper->getCountryFlagIconUrl($targetCountryCode),
            'country_name' => $this->customApisHelper->getCountryName($targetCountryCode),
            'store_url' => $this->customApisHelper->getStoreUrlByStoreId($targetStoreId),
            'currency_symbol' => $this->customApisHelper->getCurrencySymbol($targetStoreId),
        ];
        $countryData['shop_to'] = $shopTo;

        $finalArray[] = $countryData;
        return $finalArray;
    }

}
