<?php

namespace Xtwo\CustomApis\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Xtwo\CustomApis\Api\HomepageMetaDataInterface;
use Magento\Store\Model\StoreManagerInterface;

class HomepageMetaData implements HomepageMetaDataInterface
{
    protected $scopeConfig;
    protected $storeManager;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        StoreManagerInterface $storeManager
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
    }

    /**
     * @inheritdoc
     */
    public function getHomePageTags()
    {
        $seoSettings = [
            'meta_title' => $this->storeManager->getStore()->getConfig('design/head/default_title'),
            'meta_description' => $this->storeManager->getStore()->getConfig('design/head/default_description'),
            'meta_robots' => $this->storeManager->getStore()->getConfig('design/search_engine_robots/default_robots'),
            'meta_keywords' => $this->storeManager->getStore()->getConfig('design/head/default_keywords')
        ];
        return [$seoSettings];
    }
}
