<?php

namespace Xtwo\CustomApis\Model;

use Magento\Customer\Api\AccountManagementInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Xtwo\CustomApis\Api\CreatePasswordInterface;
use Magento\Framework\Exception\NotFoundException;

class CreatePassword implements CreatePasswordInterface
{
    private $accountManagement;

    public function __construct(
        AccountManagementInterface $accountManagement
    ) {
        $this->accountManagement = $accountManagement;
    }

    /**
     * @inheritdoc
     */
    public function createPassword($data)
    {
        $currentPassword = $data['current_password'];
        $newPassword = $data['new_password'];
        $customerEmail = $data['customer_email'];

        if($currentPassword === $newPassword){
            throw new \Magento\Framework\Exception\NotFoundException(__('Current password and new password can not be the same'));
        }

        $this->accountManagement->authenticate($customerEmail, $currentPassword);
        $this->accountManagement->changePassword($customerEmail, $currentPassword, $newPassword);
        return 'Password updated successfully';
    }
}
