<?php
namespace Xtwo\CustomApis\Model;

use Xtwo\CustomApis\Api\ConvertJsonInterface;
use Magento\Framework\Filesystem\DirectoryList;
use Magento\Store\Model\StoreManagerInterface;


class ConvertJson implements ConvertJsonInterface
{
	protected $rootDirectory;
	 /**
     * Convert CSV to JSON
     *
     * @return string
     */
	public function __construct(
        DirectoryList $directoryList,
		StoreManagerInterface $storeManager
    ) {
        $this->rootDirectory = $directoryList->getRoot();
		$this->storeManager = $storeManager;
    }
    public function convertCsvToJson() {
		
		$rootPath = $this->rootDirectory;
		
		$languageCode = $this->storeManager->getStore()->getConfig('general/locale/code');
		// Open and read the CSV file
		
		if($languageCode == "zh_Hans_CN"){ $languageCode = "zn_CN"; } // for cn store the lang code is zh_Hans_CN
		
			$csv_file_name = $languageCode.'.csv'; // My file name is 1_23.csv
			$file_name = $rootPath.'/app/design/frontend/Xtwo/base/i18n/'.$csv_file_name; 
			
			$csvFile = $file_name;
			$file = fopen($csvFile, 'r');

			if ($file) {
				$jsonArray = [];

				while (($line = fgetcsv($file)) !== false) {
					// Assuming there are at least two columns in the CSV
					$key = $line[0];
					$value = $line[1];
					
					$jsonArray[$key] = $value;
					
				}
				fclose($file);
				return [$jsonArray];
				// Convert the PHP array to JSON
				$jsonString = json_encode($jsonArray, JSON_PRETTY_PRINT);

				if ($jsonString === false) {
					echo "Failed to encode JSON.";
				} else {
					// Output the JSON
					echo $jsonString;
				}
			} else {
				echo "Failed to open the CSV file.";
			}
		
		
    }
}
