<?php

namespace Xtwo\CustomApis\Model;

use Xtwo\CustomApis\Api\ContactApiInterface;
use Magento\Contact\Model\MailInterface;
use Magento\Contact\Model\ConfigInterface;
use Magento\Framework\Exception\LocalizedException;
use Psr\Log\LoggerInterface;
use Magento\Framework\DataObject;

class ContactApi implements ContactApiInterface
{
    /**
     * @var ConfigInterface
     */
    protected $contactsConfig;

    /**
     * @var MailInterface
     */
    protected $mail;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * ContactApi constructor.
     *
     * @param ConfigInterface $contactsConfig
     * @param MailInterface $mail
     * @param LoggerInterface|null $logger
     */
    public function __construct(
        ConfigInterface $contactsConfig,
        MailInterface $mail,
        LoggerInterface $logger = null
    ) {
        $this->contactsConfig = $contactsConfig;
        $this->mail = $mail;
        $this->logger = $logger;
    }

    /**
     * @inheritDoc
     */
    public function submitForm($data)
    {
        try {
            // $this->validate($data);
            $this->sendEmail($data);
            return "Contact form submitted successfully!";
        } catch (LocalizedException $e) {
            throw $e;
        } catch (\Exception $e) {
            $this->logger->critical($e);
            throw new LocalizedException(
                __("Error submitting contact form. Please try again later."),
                $e
            );
        }
    }


    /**
     * Method to send email.
     *
     * @param array $data
     * @return void
     */
    private function sendEmail($data)
    {
        $this->mail->send(
            $data['email'],
            ['data' => new DataObject($data)]
        );
    }

    /**
     * Method to validate params.
     *
     * @param array $data
     * @throws LocalizedException
     */
    // private function validate($data)
    // {
    //     if (trim($data['name'] ?? '') === '') {
    //         throw new LocalizedException(__('Enter the Name and try again.'));
    //     }
    //     if (trim($data['comment'] ?? '') === '') {
    //         throw new LocalizedException(__('Enter the comment and try again.'));
    //     }
    //     if (strpos($data['email'] ?? '', '@') === false) {
    //         throw new LocalizedException(__('The email address is invalid. Verify the email address and try again.'));
    //     }
    //     if (trim($data['hideit'] ?? '') !== '') {
    //         throw new LocalizedException(__('Invalid form submission.'));
    //     }
    // }
}
