<?php

namespace Xtwo\CustomApis\Model;

use Magento\Framework\App\Helper\AbstractHelper;
use Xtwo\Buyerprotect\Block\Adminhtml\System\Config\Documentation;

class BuyerProtect extends AbstractHelper
{
    protected $buyerProtectHelper;
    protected $documentationBlock;
    protected $tsBlock;

    public function __construct(
        \Xtwo\Buyerprotect\Helper\Data $buyerProtectHelper,
        Documentation $documentationBlock,
        \Xtwo\Buyerprotect\Block\Checkout\Form $tsBlock
    ) {
        $this->buyerProtectHelper = $buyerProtectHelper;
        $this->documentationBlock = $documentationBlock;
        $this->tsBlock = $tsBlock;
    }

    public function getBuyerProtection()
    {
        $tsId = $this->buyerProtectHelper->getTsUserId();
        $tsProductsInCart = $this->buyerProtectHelper->getTsProductsInCart();

        if (count($tsProductsInCart) > 0) {
            $currentTsProductId = array_pop($tsProductsInCart);
            $tsIsSelected = true;
            $tsIsSelectedh = true;
        }

        $conditionsLink = 'http://www.trustedshops.com/shop/protection_conditions.php?shop_id=' . $tsId;

        $finalResponse = [];

        $trustedContent = [
            'ts_id' => $tsId,
            'condition_link' => $conditionsLink,
            'saving' => 'http://www.trustedshops.com/shop/data_privacy.php?shop_id='.$tsId,
            'trusted_shop_certificate' => 'https://www.trustedshops.com/shop/certificate.php?shop_id='.$tsId,
            'trusted_shop_certificate_img' => 'buyerprotect/ts_logo.png',
        ];

        $finalResponse['trustedshop_content'] = $trustedContent;

        $dropDownCollection = $this->tsBlock->getAllTsProducts();
        $dropDownOptions = [];
        foreach ($dropDownCollection as $dropDown) {
            $price = $dropDown->getPrice();
            $taxInfo = $this->tsBlock->getTaxInfo($dropDown);
            $option = [
                'id' => $dropDown->getId() ,
                'label' => trim($dropDown->getName() . '|' . $price . '(' . $taxInfo . ')'),
            ];
            $dropDownOptions[] = $option;
        }
        $finalResponse['trustedshop_dropdown'] = $dropDownOptions;


        return [$finalResponse];
    }
}
