<?php
namespace Xtwo\CustomApis\Api;

interface CustomerReviewInterface
{
    /**
     * Get customer reviews for the account section.
     *
     * @param int $customerId
     * @param int $currentPage
     * @param int $pageSize
     * @return array
     */
    public function getCustomerReviews($customerId, $currentPage, $pageSize);
    /**
     * Get review details by review ID.
     *
     * @param int $reviewId
     * @param int $customerId
     * @return array
     */
    public function getReviewDetails($reviewId,$customerId);
}
