<?php
namespace Xtwo\CurrencyApi\Model;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Directory\Model\CurrencyFactory;
use Xtwo\CurrencyApi\Api\CurrencyInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;


/**
 * Currency API implementation.
 */
class Currency implements CurrencyInterface
{
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;
	private $currencyFactory;
	protected $scopeConfig;

    /**
     * Currency constructor.
     *
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
		CurrencyFactory $currencyFactory,
        StoreManagerInterface $storeManager,
		ScopeConfigInterface $scopeConfig
    ) {
		$this->currencyFactory = $currencyFactory;
        $this->storeManager = $storeManager;
		$this->scopeConfig = $scopeConfig;
    }

    /**
     * {@inheritdoc}
     */
    public function getCurrencyDataByStoreCode($storeCode)
    {

		try {

				$currencyData = [];
				$store = $this->storeManager->getStore($storeCode);
				$currencyCollections = $this->scopeConfig->getValue(
				'currency/options/allow',
				\Magento\Store\Model\ScopeInterface::SCOPE_STORE,
				$store->getCode()
				);

				$currencyCollection = explode(',', $currencyCollections);
				$currency1 = $this->currencyFactory->create()->load($store->getBaseCurrencyCode());
				$currency = $this->currencyFactory->create()->load($store->getDefaultCurrencyCode());

				$currencyData['name']['base_currency'] = $store->getBaseCurrencyCode(); // base currency code

				$currencyData['name']['base_currency_symbol'] = $currency1->getCurrencySymbol();	// base currency symbol

				$currencyData['name']['default_currency'] = $store->getDefaultCurrencyCode(); // default currency code

				if($currency->getCurrencySymbol() == "")
				 {
					$currencyData['name']['default_currency_symbol'] = $store->getDefaultCurrencyCode(); // default currency symbol
				 }
				 else
				 {
				  $currencyData['name']['default_currency_symbol'] = $currency->getCurrencySymbol(); // default currency symbol
				 }

				$data =[];
				foreach ($currencyCollection as $key=>$value) {

					 $currency = $this->currencyFactory->create()->load($value);

					 $data[$key]['code'] = $currencyCollection[$key];

					if($currency->getCurrencySymbol() == "")
					 {
						$data[$key]['symbol'] = $currencyCollection[$key];
					 }
					 else
					 {
					  $data[$key]['symbol'] = $currency->getCurrencySymbol();
					 }
                     
					 $data[$key]['exchange_rate'] = $this->storeManager->getStore()->getBaseCurrency()->getRate($currencyCollection[$key]);
				}
				$currencyData['name']['available_currency_codes'] = $data;
				return $currencyData;

			} catch (NoSuchEntityException $e) {
					throw new NoSuchEntityException(__('Store with code %1 does not exist.', $storeCode), $e);
				}

        return null;
    }

}
