<?php

namespace Xtwo\CountryDropDown\Plugin;

use Magento\Directory\Model\CountryInformationAcquirer;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;

class CountryInformationAcquirerPlugin
{
    const COUNTRY_CODE_PATH = 'general/country/default';

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    private $_countryFactory;
    protected $storeManager;
    protected $directoryHelper;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        \Magento\Directory\Model\CountryFactory $countryFactory,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Directory\Helper\Data $directoryHelper
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->_countryFactory = $countryFactory;
        $this->directoryHelper = $directoryHelper;
        $this->storeManager = $storeManager;
    }

    public function afterGetCountriesInfo(CountryInformationAcquirer $subject, $countries)
    {
        $defaultCountryCode = $this->scopeConfig->getValue(self::COUNTRY_CODE_PATH, ScopeInterface::SCOPE_WEBSITES);
        $defaultCountry = $this->getCountryName($defaultCountryCode);
        $allowedCountries = [];
        $store = $this->storeManager->getStore();
        $countries = $this->directoryHelper->getCountryCollection($store);
        foreach ($countries as $country) {
            $regions = $this->directoryHelper->getRegionData();
            $countryData = [
                'id' => $country->getId(),
                'full_name_locale' => $this->getCountryName($country->getId()),
                'is_region_required' => $this->directoryHelper->isRegionRequired($country->getId()),
                'available_regions' => []
            ];
            if (isset($regions[$country->getId()])) {
                foreach ($regions[$country->getId()] as $regionId => $regionName) {
                    $countryData['available_regions'][] = [
                        'id' => $regionId,
                        'code' => $regionName['code'],
                        'name' => $regionName['name']
                    ];
                }
            }
            $allowedCountries[] = $countryData;
        }
        $finalArray[] = [
            'default_country' => $defaultCountry,
            'allowed_country' => $allowedCountries
        ];

        return $finalArray;
    }
    private function getCountryName($countryCode){
        $countryCollection = $this->_countryFactory->create()->loadByCode($countryCode);
        return $countryCollection->getName();
    }
}
