<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_CoreHelpers
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 * @author      Hemendra Ajmera
 * 
 * @method Xtwo_CoreHelpers_Model_Ftp_FileProxy setLocalFilePath(string $path)
 * @method Xtwo_CoreHelpers_Model_Ftp_FileProxy setRemoteFileName(string $name)
 * @method Xtwo_CoreHelpers_Model_Ftp_FileProxy setRemoteFilePath(string $name)
 * @method Xtwo_CoreHelpers_Model_Ftp_FileProxy setIsDownloaded(bool $value)
 * @method Xtwo_CoreHelpers_Model_Ftp_FileProxy setIsUploaded(bool $value)
 * @method Xtwo_CoreHelpers_Model_Ftp_FileProxy setIsInvalid(bool $value)
 * @method Xtwo_CoreHelpers_Model_Ftp_FileProxy setLastModifiedTimestamp(int $value)
 * @method Xtwo_CoreHelpers_Model_Ftp_FileProxy setRemotePath($path)
 * @method Xtwo_CoreHelpers_Model_Ftp_FileProxy setProblemReason($value)
 * @method bool getIsDownloaded()
 * @method bool getIsUploaded()
 * @method string getRemoteFilePath()
 * @method string getRemoteFileName()
 * @method string getLocalFilePath()
 * @method int getLastModifiedTimestamp()
 * @method string getRemotePath()
 * @method bool getIsInvalid()
 * @method string getProblemReason()
 */

namespace Xtwo\CoreHelpers\Model\Ftp;
 
use Magento\Framework\Model\AbstractModel;

class FileProxy extends AbstractModel
{

    /** @return string basename (last path element) of the directory path. May return empty string */
    public function getRemotePathName() {
        if ($path = $this->getRemotePath()) {
            return basename($path);
        }
        return '';
    }

    /** @return string the basename of the local file */
    public function getLocalFileName() {
        $value = $this->getLocalFilePath() ? basename($this->getLocalFilePath()) : '';
        return $value;
    }
}