<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_CoreHelpers
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 * @author      Hemendra Ajmera
 * 
 * 
 * @method Justselling_CoreHelpers_Model_Ftp_FileFilter setCountLimit($value)
 */

namespace Xtwo\CoreHelpers\Model\Ftp;
 
use Magento\Framework\Model\AbstractModel;

class FileFilter extends AbstractModel
{
    protected static $_filesToBeIgnored = array('.', '..');
    protected $_nameFilterPatterns = array();
    protected $_ageLimitSec = null;
    protected $_filesToIgnore = array();

    /**
     * Matches given file name regarding to registered filename patterns.
     * @param $fileName
     * @return bool
     */
    public function isNameReleased($fileName) {
        $ignore = array_merge(self::$_filesToBeIgnored, $this->_filesToIgnore);
        if (in_array($fileName, $ignore)) {
            return false;
        }
        if (!empty($this->_nameFilterPatterns)) {
            foreach ($this->_nameFilterPatterns as $nameFilterPattern) {
                if (preg_match('/'.$nameFilterPattern.'/i', $fileName)) return true;
            }
            return false;
        }
        return true;
    }

    /**
     * @param $timeInSeconds
     * @return bool true if given time is older than the limit
     */
    public function isAgeReleased($timeInSeconds) {
        $isReleased = true;
        if ($timeInSeconds > 0 && !is_null($this->_ageLimitSec)) {
            $limit = time() - $this->_ageLimitSec;
            return $timeInSeconds < $limit;
        }
        return $isReleased;
    }

    /**
     * @var int $sec
     * @return Xtwo_CoreHelpers_Model_Ftp_FileFilter
     */
    public function setAgeLimitInSec($sec) {
        $this->_ageLimitSec = (int) $sec;
        return $this;
    }

    /** @return the limit for max. downloaded files. Default: 1 */
    public function getCountLimit() {
        $value = $this->getData('count_limit');
        return $value ? $value : 1;
    }

    /** @return bool */
    public static function isFileToIgnore($fileName) {
        return in_array($fileName, self::$_filesToBeIgnored);
    }

    /** @param array|string $pattern
     *  @return Xtwo_CoreHelpers_Model_Ftp_FileFilter
     */
    public function addNameFilterPattern($pattern) {
        if (is_array($pattern)) {
            $this->_nameFilterPatterns = array_merge($this->_nameFilterPatterns, $pattern);
        } else $this->_nameFilterPatterns[] = $pattern;
        return $this;
    }

    /**
     * @param $name filename, no pattern supported
     * @return Xtwo_CoreHelpers_Model_Ftp_FileFilter
     */
    public function addFileNameToIgnore($name) {
        if (!empty($name)) {
            $this->_filesToIgnore[] = $name;
        }
        return $this;
    }
}