<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_CoreHelpers
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 * @author      Hemendra Ajmera
 * @method Justselling_CoreHelpers_Model_Ftp_DirectoryFilter setCountLimit($value)
 */

namespace Xtwo\CoreHelpers\Model\Ftp;
 
use Magento\Framework\Model\AbstractModel;

class DirectoryFilter extends AbstractModel
{

    /** @return int the limit for max. downloaded files. Default: PHP_INT_MAX */
    public function getCountLimit() {
        $value = $this->getData('count_limit');
        return $value ? $value : PHP_INT_MAX;
    }

    /**
     *
     * @param $path should start with '/' (slash)
     * @return Xtwo_CoreHelpers_Model_Ftp_DirectoryFilter
     */
    public function setPath($path) {
        if ((strlen($path) && $path[0] != '/') || empty($path)) {
            $path = '/'.$path;
        }
        return $this->setData('path', $path);
    }

    /** @return string */
    public function getPath() {
        $path = $this->getData('path');
        return is_null($path) ? '/' : $path;
    }
}