<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_CoreHelpers
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 * @author      Hemendra Ajmera
 *
 *
 * @method Justselling_CoreHelpers_Model_Ftp_Credentials setPassword(string $pw)
 * @method Justselling_CoreHelpers_Model_Ftp_Credentials setUsername(string $username)
 * @method Justselling_CoreHelpers_Model_Ftp_Credentials setConnectTimeout(int $sec)
 * @method Justselling_CoreHelpers_Model_Ftp_Credentials setConnectRetries(int $value)
 * @method Justselling_CoreHelpers_Model_Ftp_Credentials setPassiveMode(int $value=1)
 * @method Justselling_CoreHelpers_Model_Ftp_Credentials setPort(int $value=21)
 * @method Justselling_CoreHelpers_Model_Ftp_Credentials setRemoteBasePath($value)
 * @method string getHost()
 * @method string getPassword()
 * @method string getUsername()
 * @method string getRemoteBasePath()
 * @method int getConnectRetries()
 */

namespace Xtwo\CoreHelpers\Model\Ftp;
 
use Magento\Framework\Model\AbstractModel;

class Credentials extends AbstractModel
{
    const DEFAULT_PORT = 21;
    const DEFAULT_TIMEOUT_CONNECT = 90;
    const DEFAULT_PASSIVE_MODE_ACTIVE = 1;

    /**
     * @param $name example: 'ftp.justselling.de'
     * @return Xtwo_CoreHelpers_Model_Ftp_Credentials
     */
    public function setHost($name) {
        return $this->setData('host', $name);
    }

    /** @return int|mixed */
    public function getPort() {
        $port = $this->getData('port');
        return $port ? $port : self::DEFAULT_PORT;
    }

    /** @return int */
    public function getConnectTimeout() {
        $value = $this->getData('connect_timeout');
        return $value ? (int) $value : self::DEFAULT_TIMEOUT_CONNECT;
    }

    /** @return int */
    public function getPassiveMode() {
        if ($this->hasData('passive_mode')) {
            return $this->getData('passive_mode');
        }
        return self::DEFAULT_PASSIVE_MODE_ACTIVE;
    }
}