<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_CoreHelpers
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 * @author      Hemendra Ajmera
 */

 namespace Xtwo\CoreHelpers\Helper;

 use \Magento\Framework\App\Helper\AbstractHelper;

 class StringHelper extends AbstractHelper
 {
    
    const ALPHANUM = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    const ALPHA = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    public static $_REPLACE_SPECIAL = array('ä'=>'a', 'ö'=>'o', 'ü'=>'u', 'ß'=>'ss');

    /**
     * Filters the given subject string to the characters in the chars string.
     * @param string $subject
     * @param string $chars
     * @param array $replace
     * @return string
     */
    public function filterChars($subject, $chars, $replace=array()) {
        $subject = utf8_decode($subject);
        $chars = utf8_decode($chars);
        $repl = array();
        foreach ($replace as $key => $value) {
            $repl[utf8_decode($key)] = $value;
        }
        
        $letters = str_split($subject);
        $filter = str_split($chars);
        $result = array();
        foreach ($letters as $letter) {
            if (!empty($repl) && array_key_exists($letter, $repl)) {
                $result[] = $repl[$letter];
            } else if (in_array($letter, $filter)) $result[] = $letter;
        }        
        $filtered = implode('', $result);
        $filtered = utf8_encode($filtered);
        return $filtered;
    }

	/**
	 * Returns true if a string ends with $end, false othewise.
	 * @param $whole
	 * @param $end
	 * @return bool
	 */
	function stringEndsWith($whole, $end) {
		return (strpos($whole, $end, strlen($whole) - strlen($end)) !== false);
	}

	/**
	 * Returns true if a string ends with $end, false othewise.
	 * @param $whole
	 * @param $end
	 * @return bool
	 */
	public static function isStringEndsWith($whole, $end) {
		$helper = new Justselling_CoreHelpers_Helper_StringHelper();
		return $helper->stringEndsWith($whole, $end);
	}

    /**
     * Parses the given value as float. It's not guaranteed to keep all number formats but it can handle
     * dot and comma as decimal separator and dots and comma as thousand separator extremely graceful!
     * It can handle:
     * toFloat('1.887,78 ?')
     * toFloat('1887,78')
     * toFloat('1887.78')
     * toFloat('1,887.78')
     * toFloat('23.221.887,01')
     * toFloat('1.887,78 EUR')
     * toFloat('1887')
     * toFloat('0.343434')
     * toFloat(',343434')
     * @param $value
     * @return float even 0 an any type of syntactical error or a non-numeric value, like floatval()
     */
    public function toFloat($value) {
        $dotPos = strrpos($value, '.');
        $commaPos = strrpos($value, ',');
        $sep = (($dotPos > $commaPos) && $dotPos !== false) ? $dotPos :
            ((($commaPos > $dotPos) && $commaPos !== false) ? $commaPos : false);

        if (!$sep) {
            if (strlen($value) && ($dotPos === 0 || $commaPos === 0)) { // only for ',98'
                $value = '0'.$value; $sep = 1;
            } else {
                return floatval(preg_replace('/[^0-9]/', '', $value));
            }
        }

        return floatval(
            preg_replace('/[^0-9]/', '', substr($value, 0, $sep)) . '.' .
            preg_replace('/[^0-9]/', '', substr($value, $sep+1, strlen($value)))
        );
    }
}