<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_CoreHelpers
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

 namespace Xtwo\CoreHelpers\Helper;

 use \Magento\Framework\App\Helper\AbstractHelper;

 class Quote extends AbstractHelper
 {
    private $quoteItemFactory;
    public function __construct(
        \Magento\Quote\Model\Quote\ItemFactory $quoteItemFactory,
        \Magento\Quote\Model\ResourceModel\Quote\Item $itemResourceModel
      ) {
         $this->quoteItemFactory = $quoteItemFactory;
         $this->itemResourceModel = $itemResourceModel;
      }
    /**
     * Loads any existing options to the given QuoteItem. Sometimes they're not loaded (for any reason)
     * @param Mage_Sales_Model_Quote_Item $quoteItem
     * @return Mage_Sales_Model_Quote_Item
     */
    public function loadOptionsToQuoteItem($quoteItem) {
        /** @var Mage_Sales_Model_Resource_Quote_Item_Option_Collection $options */
        $quote = $this->quoteItemFactory->create();
        $options=$this->itemResourceModel->load($quote, $quoteItem->getId());
        //$options = Mage::getResourceModel('sales/quote_item_option_collection');
        //$options->addItemFilter($quoteItem->getId());
        foreach ($options as $option) {
            $quoteItem->addOption($option);
        }
        return $quoteItem;
    }
 }