<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_CoreHelpers
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

 namespace Xtwo\CoreHelpers\Helper;

 use \Magento\Framework\App\Helper\AbstractHelper;

 class Network extends AbstractHelper
 {
    /**
	 * compare given ip with a range
	 * e.g. [0-255].[0-255].[0-255].[0-255] covers ip like 192.169.1.1
	 * e.g. [192].[168].[1].[0-255] cover ip like 192.168.1.0-255
	 * e.g. [192].[168].[1].[128] cover only ip 192.168.1.128
	 *
	 * @param string ip to check e.g. 192.168.0.1
	 * @param string range to check for e.g. [0-255].[0-255].[0-255].[0-255]
	 * @return bool
	 */
	public static function validateIpV4Range ($target, $range) {
		$counter = (int) 0;
		// explode target ip
		$tip = explode ('.', $target);
		// explode range ip
		$rip = explode ('.', $range);
		$result = true;
		foreach ($tip as $targetsegment) {
			// get appropriate range segm.
			$rseg = $rip[$counter];
			// strip brackets
			$rseg = preg_replace ('=(\[|\])=', '', $rseg);
			// explode min max
			$rseg = explode ('-', $rseg);
			// no max value
			if (!isset($rseg[1]))
				$rseg[1] = $rseg[0];
			// compare
			if ($targetsegment < $rseg[0] || $targetsegment > $rseg[1]) {
				$result = false;
				break;
			}
			$counter++;
		}
		return $result;
	}

	/**
	 * @param $target
	 * @param array $ranges
	 * @return bool
	 */
	public static function validateIpV4Ranges($target, array $ranges) {
		$result = false;
		foreach ($ranges as $range) {
			$result = self::validateIpV4Range($target, $range);
			if ($result) {
				$result = true;
				break;
			}
		}
		Js_Log::log(sprintf("Validating IP %s, %s", $target, $result ? 'released!' : 'blocked!'), 'jscoreutils');
		return $result;
	}
 }