<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_CoreHelpers
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

 namespace Xtwo\CoreHelpers\Helper;

 use \Magento\Framework\App\Helper\AbstractHelper;

 class Ftp extends AbstractHelper
 {
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Xtwo\CoreHelpers\Model\Ftp\Credentials $ftpCredentials,
        \Xtwo\CoreHelpers\Model\Ftp\Client $ftpClient
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
        $this->ftpCredentials= $ftpCredentials;
        $this->ftpClient=$ftpClient;
        parent::__construct(
            $context
        );
    }
    /**
     * Returns configured FtpClient. Ensure to have configuration in your module like this:<br/>
     * <pre>
     * <js_ftp>
     *         <imageimport>
     *             <development>
     *                 <host>cloud60.justselling.de</host>
     *                 <user>magecloud239576</user>
     *                 <pw>K3hV4g#2j4gG</pw>
     *                 <basepath>web/media/productimage_import</basepath><!-- if root is not path to work -->
     *             </development>
     *   ...
     * </pre>
     * @param string $usage
     * @return Justselling_CoreHelpers_Model_Ftp_Client
     * @throws Mage_Exception
     */
    public function getFtpClient($usage='default') {
        $systemScope = Js_SystemMode::getSystemScope();
        $ftpAccountNode = Mage::getConfig()->getNode('js_ftp/'.$usage.'/'.$systemScope);
        $accountData = $ftpAccountNode->asArray();

        if (empty($accountData)) {
            throw new \Magento\Framework\Exception\LocalizedException('ftp account configuration <js_ftp><'.$usage.'> missing!');
        }
        $credentials = $this->ftpCredentials
            ->setHost($accountData['host'])
            ->setUsername($accountData['user'])
            ->setPassword($accountData['pw']);
        if (isset($accountData['port'])) {
            $credentials->setPort((int) $accountData['port']);
        }
        if ($basePath = $accountData['basepath']) {
            $credentials->setRemoteBasePath($basePath);
        }
        $client = $this->ftpClient->init($credentials);
        return $client;
    }
 }