<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_CoreHelpers
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 */

 namespace Xtwo\CoreHelpers\Helper;

 use \Magento\Framework\App\Helper\AbstractHelper;

 class File extends AbstractHelper
 {
    /**
	 * Returns all filenames (absolute path) of a folder as a simple array. Does not work recursively!
	 * @param $path string valid path name (must be directory)
	 * @param $regexInclFilter regex pattern for include-filter
	 * @return array array of string with absolute paths, may return empty array
	 */
	public function getFilesOfFolder($path, $regexInclFilter=null) {
		$files = array();
		if (empty($path)) return $files;
		if (!is_dir($path)) {
			//Js_Log::log(sprintf("Path is not a folder: %s", $path, $this, Zend_Log::ERR));
			return $files;
		}
		$it = new DirectoryIterator($path);
		if (!$it->isReadable()) {
			//Js_Log::log(sprintf("Cannot read from path %s", $it->getPath()), $this, Zend_Log::ERR);
			return $files;
		}
		/* @var $fileInfo SplFileInfo */
		foreach ($it as $fileInfo) {
			if ($fileInfo->isDir() || $fileInfo->isLink() || $fileInfo->getFilename() == '.'
				|| $fileInfo->getFilename() == '..' || $fileInfo->getFilename() == '.DS_Store') {
				continue; // ignore
			}
			if (!empty($regexInclFilter)) {
				if (preg_match('/'.$regexInclFilter.'/', $fileInfo->getFilename())) {
					$files[] = $path.DS.$fileInfo->getFileName();
				}
			} elseif ($fileInfo->isFile()) {
				$files[] = $path.DS.$fileInfo->getFileName();
			}
		}
		return $files;
	}

	/**
	 * Recursive copy of folders.
	 *
	 * @param $source string
	 * @param $dest string
	 */
	public function copyr($source, $dest) {
		// recursive function to copy
		// all subdirectories and contents:
		if(is_dir($source)) {
			$dir_handle=opendir($source);
			$sourceFolder = basename($source);
			if (!file_exists($dest."/".$sourceFolder)) {
				mkdir($dest."/".$sourceFolder);
			}
			while($file=readdir($dir_handle)){
				if($file!="." && $file!=".."){
					if(is_dir($source."/".$file)){
						self::copyr($source."/".$file, $dest."/".$sourceFolder);
					} else {
						copy($source."/".$file, $dest."/".$file);
					}
				}
			}
			closedir($dir_handle);
		} else {
			// can also handle simple copy commands
			copy($source, $dest);
		}
	}
 }