<?php
namespace Xtwo\CategoryProductGrid\Block\Adminhtml\Category\Tab;

use Magento\Catalog\Model\Product\Attribute\Source\Status;
use Magento\Catalog\Model\Product\Visibility;

class Product extends \Magento\Catalog\Block\Adminhtml\Category\Tab\Product
{
    protected $attributeRepository;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Backend\Helper\Data $backendHelper,
        \Magento\Catalog\Model\ProductFactory $productFactory,
        \Magento\Framework\Registry $coreRegistry,
        \Magento\Catalog\Model\Product\Attribute\Repository $attributeRepository,
        \Magento\Catalog\Model\Product\AttributeSet\Options $attributeoptions,
        array $data = [],
        Visibility $visibility = null,
        Status $status = null
    )
    {
        $this->attributeRepository = $attributeRepository;
        $this->attributeoptions = $attributeoptions;
        parent::__construct($context, $backendHelper, $productFactory, $coreRegistry, $data, $visibility, $status);
    }

    /**
     * @return \Magento\Backend\Block\Widget\Grid
     */
    protected function _prepareCollection()
    {
        $grid = parent::_prepareCollection();

        $collection = $this->getCollection()->addAttributeToSelect(['series','type','type2','manufacturer'])->addFieldToSelect('attribute_set_name');

        $collection->getSelect()->joinLeft(array('as' => 'eav_attribute_set'),
        'as.attribute_set_id = e.attribute_set_id');

        $this->setCollection($collection);
        if ($this->getCollection()->isLoaded()) {
            $this->getCollection()->clear();
        }

        return $grid;
    }

    /**
     * @return \Magento\Backend\Block\Widget\Grid\Extended
     */
    protected function _prepareColumns()
    {
        try {
            $this->addColumnAfter(
                'manufacturer',
                [
                    'header' => __('Manufacturer'),
                    'name' => 'manufacturer',
                    'index' => 'manufacturer',
                    'type' => 'options',
                    'options'   => $this->getManufacturerOptionArray()
                ], 'sku'
            );
            $this->addColumnAfter(
                'series',
                [
                    'header' => __('Series'),
                    'name' => 'series',
                    'index' => 'series',
                    'type' => 'options',
                    'options'   => $this->getSeriesOptionArray()
                ],'manufacturer'
            );
            $this->addColumnAfter(
                'type',
                [
                    'header' => __('Type'),
                    'name' => 'type',
                    'index' => 'type',
                    'type' => 'options',
                    'options'   => $this->getTypeOptionArray()
                ],'series'
            );
            $this->addColumnAfter(
                'type2',
                [
                    'header' => __('Variant'),
                    'name' => 'type2',
                    'index' => 'type2',
                    'type' => 'options',
                    'options'   => $this->getVariantOptionArray()
                ],'type'
            );
            $this->addColumnAfter(
                'attribute_set_name',
                [
                    'header' => __('Attribute Set'),
                    'name' => 'attribute_set_name',
                    'index' => 'attribute_set_id',
                    'type' => 'options',
                    'options'   => $this->getAttributeOptionArray()
                ],'type2'
            );

            parent::_prepareColumns();

        }
        catch (\Exception $e){
            //Do nothing
        }

        return $this;
    }

    public function getManufacturerOptionArray()
    {
        $options = $this->attributeRepository->get("manufacturer")->setStoreId(0)->getOptions();
        $optionsArray = [];
        foreach ($options as $option){
            if($option->getValue() == 0){
                continue;
            }
            $optionsArray[$option->getValue()] = $option->getLabel();
        }

        asort($optionsArray);
        return ($optionsArray);
    }

    public function getSeriesOptionArray()
    {
        $options = $this->attributeRepository->get("series")->setStoreId(0)->getOptions();
        $optionsArray = [];
        foreach ($options as $option){
            if($option->getValue() == 0){
                continue;
            }
            $optionsArray[$option->getValue()] = $option->getLabel();
        }

        asort($optionsArray);
        return ($optionsArray);
    }

    public function getTypeOptionArray()
    {
        $options = $this->attributeRepository->get("type")->setStoreId(0)->getOptions();
        $optionsArray = [];
        foreach ($options as $option){
            if($option->getValue() == 0){
                continue;
            }
            $optionsArray[$option->getValue()] = $option->getLabel();
        }

        asort($optionsArray);
        return ($optionsArray);
    }

    public function getVariantOptionArray()
    {
        $options = $this->attributeRepository->get("type2")->setStoreId(0)->getOptions();
        $optionsArray = [];
        foreach ($options as $option){
            if($option->getValue() == 0){
                continue;
            }
            $optionsArray[$option->getValue()] = $option->getLabel();
        }

        asort($optionsArray);
        return ($optionsArray);
    }

    public function getAttributeOptionArray()
    {
        $options = $this->attributeoptions->toOptionArray();
        $optionsArray = [];
        foreach ($options as $option){
            $optionsArray[$option['value']] = $option['label'];
        }
        asort($optionsArray);
        return ($optionsArray);
    }
}
