<?php
namespace Xtwo\CategoryPosition\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\ObjectManagerInterface;


class CategoryProductIds implements ObserverInterface
{
    public $objectmanager;

    public function __construct(
        ObjectManagerInterface $objectmanager
    ) {
        $this->objectmanager = $objectmanager;
    }

    /**
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer): void
    {
        $productIds = $observer->getEvent()->getProductIds();
        $category = $observer->getEvent()->getCategory();

        /**
         * old category-product relationships
         */
        $affectedProducts = $productIds;
        $oldProducts = array_keys($category->getProductsPosition());

        $insert = array_diff($affectedProducts, $oldProducts);
        $deleted = array_diff($affectedProducts, $insert);

        $categoryId = $category->getId();

        $category = $this->objectmanager->get('\Magento\Catalog\Model\CategoryFactory')->create()->load($categoryId);
        $products = $category->getProductsPosition();
        $productIdArray = [];

        foreach ($products as $id => $value) {
            if (in_array($id, $insert)) {
                $products[$id] = 1000;
            } 
        }
                
        $category->setPostedProducts($products);
        $category->save();

    }
}