<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace Xtwo\CategoryPosition\Model\Import;

use Magento\Framework\ObjectManagerInterface;

class CsvSimpleFormatHandler extends CsvHandlerAbstract
{
    public $objectmanager;
    /**
     * CsvSimpleFormatHandler constructor.
     *
     * @param \Magento\Framework\File\Csv $csvProcessor
     */
    
    public function __construct(
        \Magento\Framework\File\Csv $csvProcessor,
        ObjectManagerInterface $objectmanager
    ) {
        parent::__construct($csvProcessor);
        $this->objectmanager = $objectmanager;
    }

    /**
     * {@inheritdoc}
     */
    protected function validateByDataFormat(array $data)
    {
        $uniqueArray = [];

        foreach ($data as $rowIndex => $dataRow) {
            if ($dataRow[0] === '') {
                throw new \Magento\Framework\Exception\LocalizedException(
                    __('Missed sku in line %1', $rowIndex + 2)
                );
            } else {
                if(!$this->objectmanager->get('Magento\Catalog\Model\Product')->getIdBySku($dataRow[0])){
                    throw new \Magento\Framework\Exception\LocalizedException(
                        __('Product not exist please check SKU in line %1', $rowIndex + 2)
                    );
                }
            }

            if ($dataRow[1] === '') {
                throw new \Magento\Framework\Exception\LocalizedException(
                    __('Missed category_id in line %1', $rowIndex + 2)
                );
            }

            if ($dataRow[2] === '') {
                throw new \Magento\Framework\Exception\LocalizedException(
                    __('Missed position in line %1', $rowIndex + 2)
                );
            }
        }

        return true;
    }

    /**
     * {@inheritdoc}
     */
    protected function import(array $importData)
    {
        $categoryArray = [];
        foreach ($importData as $key => $data) {
            $productsku = $data[0];
            $categoryId = $data[1];
            $newposition = $data[2];
            $product = $this->objectmanager->get('Magento\Catalog\Api\ProductRepositoryInterface')->get($productsku);
            $productId = $product->getId();
            $categoryIds = $product->getCategoryIds();
            $prodArray['productAssign'] = in_array($categoryId, $categoryIds) ? 0 : 1;
            $prodArray['productId'] = $productId;
            $prodArray['sku'] = $productsku;
            $prodArray['newposition'] = $newposition;
            if (isset($categoryArray[$categoryId])) {
                array_push($categoryArray[$categoryId], $prodArray);
            } else {
                $categoryArray[$categoryId][] = $prodArray;
            }
        }

        /* Category Positions */

        foreach($categoryArray as $categoryId => $productInfo) {
            
            foreach ($productInfo as $prodData) {
                if($prodData['productAssign']){
                    $sku = $prodData['sku'];
                    $categoryLinkRepository = $this->objectmanager->get('\Magento\Catalog\Api\CategoryLinkManagementInterface');
                    $categoryIds = array($categoryId);
                    $categoryLinkRepository->assignProductToCategories($sku, $categoryIds);
                }
            }

            $category = $this->objectmanager->get('\Magento\Catalog\Model\CategoryFactory')->create()->load($categoryId);
            $products = $category->getProductsPosition();
            $productIdArray = [];

            foreach ($productInfo as $prodData) {
                foreach ($products as $id => $value) {
                    if ($id == $prodData['productId']) {
                        $products[$id] = $prodData['newposition'];
                    } 
                }
            }
            
            $category->setPostedProducts($products);
            $category->save();
        }
    }
}
