<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace Xtwo\CategoryPosition\Model\Import;

abstract class CsvHandlerAbstract
{
    /**
     * CSV Processor
     *
     * @var \Magento\Framework\File\Csv
     */
    protected $csvProcessor;

    /**
     * CsvHandlerAbstract constructor.
     *
     * @param \Magento\Framework\File\Csv $csvProcessor
     */
    public function __construct(
        \Magento\Framework\File\Csv $csvProcessor
    ) {
        $this->csvProcessor = $csvProcessor;
    }

    /**
     * @param array $data
     * @return bool
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    abstract protected function validateByDataFormat(array $data);

    /**
     * @param array $storeSplitData
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    abstract protected function import(array $storeSplitData);

    /**
     * @param array $file file info retrieved from $_FILES array
     * @throws \Exception
     * @throws \Magento\Framework\Exception\AlreadyExistsException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function importFromCsvFile($file)
    {
        if (!isset($file['tmp_name'])) {
            throw new \Magento\Framework\Exception\LocalizedException(__('Invalid file upload attempt.'));
        }
        $importData = $this->csvProcessor->getData($file['tmp_name']);

        if (count($importData) < 2) {
            throw new \Magento\Framework\Exception\LocalizedException(
                __('Data for import not found')
            );
        }

        array_shift($importData);
        array_walk_recursive($importData, [$this, 'trim']);
        
        if ($this->validateData($importData)) {
            $this->import($importData);
        }
    }

    /**
     * @param array $data
     * @return bool
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    protected function validateData(array $data)
    {
        return $this->validateByDataFormat($data);
    }

    /**
     * @param $item
     * @param $key
     */
    protected function trim(&$item, $key)
    {
        $item = trim($item);
    }
}
