<?php
/**
 * Copyright ©  All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Xtwo\CategoryPosition\Controller\Adminhtml\Index;

use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\ObjectManagerInterface;

class Index implements HttpGetActionInterface
{

    /**
     * @var PageFactory
     */
    protected $resultPageFactory;

    public $messageManager;

    public $objectmanager;

    /**
     * Constructor
     *
     * @param PageFactory $resultPageFactory
     */
    public function __construct(
        PageFactory $resultPageFactory,
        ManagerInterface $messageManager,
        ObjectManagerInterface $objectmanager
    ){
        $this->resultPageFactory = $resultPageFactory;
        $this->messageManager = $messageManager;
        $this->objectmanager = $objectmanager;
    }

    /**
     * Execute view action
     *
     * @return ResultInterface
     */
    public function execute()
    {
        $this->messageManager->addNoticeMessage(
            $this->objectmanager->get(\Magento\ImportExport\Helper\Data::class)->getMaxUploadSizeMessage()
        );

        $resultPage = $this->resultPageFactory->create();
        $resultPage->getConfig()->getTitle()->set("Import Category Product/Position");
        return $resultPage;
    }
	    /**
     * Is the user allowed to view the blog post grid.
     *
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Xtwo_CategoryPosition::position');
    }
}

