<?php
/**
 * Xtwo
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the metawolf.com license that is
 * available through the world-wide-web at this URL:
 * https://www.metawolf.com/license.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Xtwo
 * @package     Xtwo_CategoryOption
 * @copyright   Copyright (c) MetaWolf (https://www.metawolf.com/)
 * @license     https://www.metawolf.com/license.txt
 * @author      Hemendra Ajmera
 */

namespace Xtwo\CategoryOption\Setup;

use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Eav\Setup\EavSetupFactory;

class InstallData implements InstallDataInterface
{

	private $eavSetupFactory;

	public function __construct(EavSetupFactory $eavSetupFactory)
	{
		$this->eavSetupFactory = $eavSetupFactory;
	}

	public function install(
		ModuleDataSetupInterface $setup,
		ModuleContextInterface $context
	)
	{
		$eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);

		$eavSetup->addAttribute(
			\Magento\Catalog\Model\Category::ENTITY,
			'description_bottom',
			[
				'type'         => 'text',
				'label'        => 'Description Bottom',
				'input'        => 'textarea',
				'sort_order'   => 100,
				'source'       => '',
				'global'       => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
				'visible'      => true,
				'required'     => false,
				'user_defined' => false,
				'default'      => null,
				'group'        => 'General Information',
				'backend'      => '',
                'visible_on_front' => true,
                'wysiwyg_enabled'   => true,
                'is_html_allowed_on_front' => true,
			]
		);
        $eavSetup->addAttribute(
			\Magento\Catalog\Model\Category::ENTITY,
			'description_top',
			[
				'type'         => 'text',
				'label'        => 'Description Top',
				'input'        => 'textarea',
				'sort_order'   => 100,
				'source'       => '',
				'global'       => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
				'visible'      => true,
				'required'     => false,
				'user_defined' => false,
				'default'      => null,
				'group'        => 'General Information',
				'backend'      => '',
                'visible_on_front' => true,
                'wysiwyg_enabled'   => true,
                'is_html_allowed_on_front' => true,
			]
		);

        $eavSetup->addAttribute(
			\Magento\Catalog\Model\Category::ENTITY,
			'description_left',
			[
				'type'         => 'text',
				'label'        => 'Description Left',
				'input'        => 'textarea',
				'sort_order'   => 100,
				'source'       => '',
				'global'       => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
				'visible'      => true,
				'required'     => false,
				'user_defined' => false,
				'default'      => null,
				'group'        => 'General Information',
				'backend'      => '',
                'visible_on_front' => true,
                'wysiwyg_enabled'   => true,
                'is_html_allowed_on_front' => true,
			]
		);
        
	}
}